
use builtin;
use str;

set edit:completion:arg-completer[tracexec] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'tracexec'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'tracexec'= {
            cand --color 'Control whether colored output is enabled. This flag has no effect on TUI mode.'
            cand -C 'Change current directory to this path before doing anything'
            cand --cwd 'Change current directory to this path before doing anything'
            cand -P 'Load profile from this path'
            cand --profile 'Load profile from this path'
            cand -u 'Run as user. This option is only available when running tracexec as root'
            cand --user 'Run as user. This option is only available when running tracexec as root'
            cand --no-profile 'Do not load profiles'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand log 'Run tracexec in logging mode'
            cand tui 'Run tracexec in TUI mode, stdin/out/err are redirected to /dev/null by default'
            cand generate-completions 'Generate shell completions for tracexec'
            cand collect 'Collect exec events and export them'
            cand ebpf 'Experimental ebpf mode'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tracexec;log'= {
            cand --inline-timestamp-format 'Set the format of inline timestamp. See https://docs.rs/chrono/latest/chrono/format/strftime/index.html for available options.'
            cand --seccomp-bpf 'Controls whether to enable seccomp-bpf optimization, which greatly improves performance'
            cand --polling-interval 'Polling interval, in microseconds. -1(default) disables polling.'
            cand --filter 'Set the default filter for events.'
            cand --filter-include 'Aside from the default filter, also include the events specified here.'
            cand --filter-exclude 'Exclude the events specified here from the default filter.'
            cand -o 'Output, stderr by default. A single hyphen ''-'' represents stdout.'
            cand --output 'Output, stderr by default. A single hyphen ''-'' represents stdout.'
            cand --more-colors 'More colors'
            cand --less-colors 'Less colors'
            cand --show-cmdline 'Print commandline that (hopefully) reproduces what was executed. Note: file descriptors are not handled for now.'
            cand --no-show-cmdline 'Don''t print commandline that (hopefully) reproduces what was executed.'
            cand --show-interpreter 'Try to show script interpreter indicated by shebang'
            cand --no-show-interpreter 'Do not show script interpreter indicated by shebang'
            cand --foreground 'Set the terminal foreground process group to tracee. This option is useful when tracexec is used interactively. [default]'
            cand --no-foreground 'Do not set the terminal foreground process group to tracee'
            cand --diff-fd 'Diff file descriptors with the original std{in/out/err}'
            cand --no-diff-fd 'Do not diff file descriptors'
            cand --show-fd 'Show file descriptors'
            cand --no-show-fd 'Do not show file descriptors'
            cand --diff-env 'Diff environment variables with the original environment'
            cand --no-diff-env 'Do not diff environment variables'
            cand --show-env 'Show environment variables'
            cand --no-show-env 'Do not show environment variables'
            cand --show-comm 'Show comm'
            cand --no-show-comm 'Do not show comm'
            cand --show-argv 'Show argv'
            cand --no-show-argv 'Do not show argv'
            cand --show-filename 'Show filename'
            cand --no-show-filename 'Do not show filename'
            cand --show-cwd 'Show cwd'
            cand --no-show-cwd 'Do not show cwd'
            cand --decode-errno 'Decode errno values'
            cand --no-decode-errno 'Do not decode errno values'
            cand --successful-only 'Only show successful calls'
            cand --fd-in-cmdline '[Experimental] Try to reproduce file descriptors in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --stdio-in-cmdline '[Experimental] Try to reproduce stdio in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --resolve-proc-self-exe 'Resolve /proc/self/exe symlink'
            cand --no-resolve-proc-self-exe 'Do not resolve /proc/self/exe symlink'
            cand --hide-cloexec-fds 'Hide CLOEXEC fds'
            cand --no-hide-cloexec-fds 'Do not hide CLOEXEC fds'
            cand --timestamp 'Show timestamp information'
            cand --no-timestamp 'Do not show timestamp information'
            cand --show-all-events 'Set the default filter to show all events. This option can be used in combination with --filter-exclude to exclude some unwanted events.'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tracexec;tui'= {
            cand --inline-timestamp-format 'Set the format of inline timestamp. See https://docs.rs/chrono/latest/chrono/format/strftime/index.html for available options.'
            cand --seccomp-bpf 'Controls whether to enable seccomp-bpf optimization, which greatly improves performance'
            cand --polling-interval 'Polling interval, in microseconds. -1(default) disables polling.'
            cand --filter 'Set the default filter for events.'
            cand --filter-include 'Aside from the default filter, also include the events specified here.'
            cand --filter-exclude 'Exclude the events specified here from the default filter.'
            cand -A 'Set the default active pane to use when TUI launches'
            cand --active-pane 'Set the default active pane to use when TUI launches'
            cand -L 'Set the layout of the TUI when it launches'
            cand --layout 'Set the layout of the TUI when it launches'
            cand -F 'Set the frame rate of the TUI (60 by default)'
            cand --frame-rate 'Set the frame rate of the TUI (60 by default)'
            cand -m 'Max number of events to keep in TUI (0=unlimited)'
            cand --max-events 'Max number of events to keep in TUI (0=unlimited)'
            cand -D 'Set the default external command to run when using "Detach, Stop and Run Command" feature in Hit Manager'
            cand --default-external-command 'Set the default external command to run when using "Detach, Stop and Run Command" feature in Hit Manager'
            cand -b 'Add a new breakpoint to the tracer. This option can be used multiple times. The format is <syscall-stop>:<pattern-type>:<pattern>, where syscall-stop can be sysenter or sysexit, pattern-type can be argv-regex, in-filename or exact-filename. For example, sysexit:in-filename:/bash'
            cand --add-breakpoint 'Add a new breakpoint to the tracer. This option can be used multiple times. The format is <syscall-stop>:<pattern-type>:<pattern>, where syscall-stop can be sysenter or sysexit, pattern-type can be argv-regex, in-filename or exact-filename. For example, sysexit:in-filename:/bash'
            cand --successful-only 'Only show successful calls'
            cand --fd-in-cmdline '[Experimental] Try to reproduce file descriptors in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --stdio-in-cmdline '[Experimental] Try to reproduce stdio in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --resolve-proc-self-exe 'Resolve /proc/self/exe symlink'
            cand --no-resolve-proc-self-exe 'Do not resolve /proc/self/exe symlink'
            cand --hide-cloexec-fds 'Hide CLOEXEC fds'
            cand --no-hide-cloexec-fds 'Do not hide CLOEXEC fds'
            cand --timestamp 'Show timestamp information'
            cand --no-timestamp 'Do not show timestamp information'
            cand --show-all-events 'Set the default filter to show all events. This option can be used in combination with --filter-exclude to exclude some unwanted events.'
            cand -t 'Allocate a pseudo terminal and show it alongside the TUI'
            cand --tty 'Allocate a pseudo terminal and show it alongside the TUI'
            cand -f 'Keep the event list scrolled to the bottom'
            cand --follow 'Keep the event list scrolled to the bottom'
            cand --terminate-on-exit 'Instead of waiting for the root child to exit, terminate when the TUI exits'
            cand --kill-on-exit 'Instead of waiting for the root child to exit, kill when the TUI exits'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tracexec;generate-completions'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tracexec;collect'= {
            cand --inline-timestamp-format 'Set the format of inline timestamp. See https://docs.rs/chrono/latest/chrono/format/strftime/index.html for available options.'
            cand --seccomp-bpf 'Controls whether to enable seccomp-bpf optimization, which greatly improves performance'
            cand --polling-interval 'Polling interval, in microseconds. -1(default) disables polling.'
            cand -F 'the format for exported exec events'
            cand --format 'the format for exported exec events'
            cand -o 'Output, stderr by default. A single hyphen ''-'' represents stdout.'
            cand --output 'Output, stderr by default. A single hyphen ''-'' represents stdout.'
            cand --successful-only 'Only show successful calls'
            cand --fd-in-cmdline '[Experimental] Try to reproduce file descriptors in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --stdio-in-cmdline '[Experimental] Try to reproduce stdio in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --resolve-proc-self-exe 'Resolve /proc/self/exe symlink'
            cand --no-resolve-proc-self-exe 'Do not resolve /proc/self/exe symlink'
            cand --hide-cloexec-fds 'Hide CLOEXEC fds'
            cand --no-hide-cloexec-fds 'Do not hide CLOEXEC fds'
            cand --timestamp 'Show timestamp information'
            cand --no-timestamp 'Do not show timestamp information'
            cand -p 'prettify the output if supported'
            cand --pretty 'prettify the output if supported'
            cand --foreground 'Set the terminal foreground process group to tracee. This option is useful when tracexec is used interactively. [default]'
            cand --no-foreground 'Do not set the terminal foreground process group to tracee'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tracexec;ebpf'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand log 'Run tracexec in logging mode'
            cand tui 'Run tracexec in TUI mode, stdin/out/err are redirected to /dev/null by default'
            cand collect 'Collect exec events and export them'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tracexec;ebpf;log'= {
            cand -o 'Output, stderr by default. A single hyphen ''-'' represents stdout.'
            cand --output 'Output, stderr by default. A single hyphen ''-'' represents stdout.'
            cand --inline-timestamp-format 'Set the format of inline timestamp. See https://docs.rs/chrono/latest/chrono/format/strftime/index.html for available options.'
            cand --successful-only 'Only show successful calls'
            cand --fd-in-cmdline '[Experimental] Try to reproduce file descriptors in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --stdio-in-cmdline '[Experimental] Try to reproduce stdio in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --resolve-proc-self-exe 'Resolve /proc/self/exe symlink'
            cand --no-resolve-proc-self-exe 'Do not resolve /proc/self/exe symlink'
            cand --hide-cloexec-fds 'Hide CLOEXEC fds'
            cand --no-hide-cloexec-fds 'Do not hide CLOEXEC fds'
            cand --timestamp 'Show timestamp information'
            cand --no-timestamp 'Do not show timestamp information'
            cand --more-colors 'More colors'
            cand --less-colors 'Less colors'
            cand --show-cmdline 'Print commandline that (hopefully) reproduces what was executed. Note: file descriptors are not handled for now.'
            cand --no-show-cmdline 'Don''t print commandline that (hopefully) reproduces what was executed.'
            cand --show-interpreter 'Try to show script interpreter indicated by shebang'
            cand --no-show-interpreter 'Do not show script interpreter indicated by shebang'
            cand --foreground 'Set the terminal foreground process group to tracee. This option is useful when tracexec is used interactively. [default]'
            cand --no-foreground 'Do not set the terminal foreground process group to tracee'
            cand --diff-fd 'Diff file descriptors with the original std{in/out/err}'
            cand --no-diff-fd 'Do not diff file descriptors'
            cand --show-fd 'Show file descriptors'
            cand --no-show-fd 'Do not show file descriptors'
            cand --diff-env 'Diff environment variables with the original environment'
            cand --no-diff-env 'Do not diff environment variables'
            cand --show-env 'Show environment variables'
            cand --no-show-env 'Do not show environment variables'
            cand --show-comm 'Show comm'
            cand --no-show-comm 'Do not show comm'
            cand --show-argv 'Show argv'
            cand --no-show-argv 'Do not show argv'
            cand --show-filename 'Show filename'
            cand --no-show-filename 'Do not show filename'
            cand --show-cwd 'Show cwd'
            cand --no-show-cwd 'Do not show cwd'
            cand --decode-errno 'Decode errno values'
            cand --no-decode-errno 'Do not decode errno values'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tracexec;ebpf;tui'= {
            cand --inline-timestamp-format 'Set the format of inline timestamp. See https://docs.rs/chrono/latest/chrono/format/strftime/index.html for available options.'
            cand --filter 'Set the default filter for events.'
            cand --filter-include 'Aside from the default filter, also include the events specified here.'
            cand --filter-exclude 'Exclude the events specified here from the default filter.'
            cand -A 'Set the default active pane to use when TUI launches'
            cand --active-pane 'Set the default active pane to use when TUI launches'
            cand -L 'Set the layout of the TUI when it launches'
            cand --layout 'Set the layout of the TUI when it launches'
            cand -F 'Set the frame rate of the TUI (60 by default)'
            cand --frame-rate 'Set the frame rate of the TUI (60 by default)'
            cand -m 'Max number of events to keep in TUI (0=unlimited)'
            cand --max-events 'Max number of events to keep in TUI (0=unlimited)'
            cand --successful-only 'Only show successful calls'
            cand --fd-in-cmdline '[Experimental] Try to reproduce file descriptors in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --stdio-in-cmdline '[Experimental] Try to reproduce stdio in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --resolve-proc-self-exe 'Resolve /proc/self/exe symlink'
            cand --no-resolve-proc-self-exe 'Do not resolve /proc/self/exe symlink'
            cand --hide-cloexec-fds 'Hide CLOEXEC fds'
            cand --no-hide-cloexec-fds 'Do not hide CLOEXEC fds'
            cand --timestamp 'Show timestamp information'
            cand --no-timestamp 'Do not show timestamp information'
            cand --show-all-events 'Set the default filter to show all events. This option can be used in combination with --filter-exclude to exclude some unwanted events.'
            cand -t 'Allocate a pseudo terminal and show it alongside the TUI'
            cand --tty 'Allocate a pseudo terminal and show it alongside the TUI'
            cand -f 'Keep the event list scrolled to the bottom'
            cand --follow 'Keep the event list scrolled to the bottom'
            cand --terminate-on-exit 'Instead of waiting for the root child to exit, terminate when the TUI exits'
            cand --kill-on-exit 'Instead of waiting for the root child to exit, kill when the TUI exits'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tracexec;ebpf;collect'= {
            cand --inline-timestamp-format 'Set the format of inline timestamp. See https://docs.rs/chrono/latest/chrono/format/strftime/index.html for available options.'
            cand -F 'the format for exported exec events'
            cand --format 'the format for exported exec events'
            cand -o 'Output, stderr by default. A single hyphen ''-'' represents stdout.'
            cand --output 'Output, stderr by default. A single hyphen ''-'' represents stdout.'
            cand --successful-only 'Only show successful calls'
            cand --fd-in-cmdline '[Experimental] Try to reproduce file descriptors in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --stdio-in-cmdline '[Experimental] Try to reproduce stdio in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
            cand --resolve-proc-self-exe 'Resolve /proc/self/exe symlink'
            cand --no-resolve-proc-self-exe 'Do not resolve /proc/self/exe symlink'
            cand --hide-cloexec-fds 'Hide CLOEXEC fds'
            cand --no-hide-cloexec-fds 'Do not hide CLOEXEC fds'
            cand --timestamp 'Show timestamp information'
            cand --no-timestamp 'Do not show timestamp information'
            cand -p 'prettify the output if supported'
            cand --pretty 'prettify the output if supported'
            cand --foreground 'Set the terminal foreground process group to tracee. This option is useful when tracexec is used interactively. [default]'
            cand --no-foreground 'Do not set the terminal foreground process group to tracee'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tracexec;ebpf;help'= {
            cand log 'Run tracexec in logging mode'
            cand tui 'Run tracexec in TUI mode, stdin/out/err are redirected to /dev/null by default'
            cand collect 'Collect exec events and export them'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tracexec;ebpf;help;log'= {
        }
        &'tracexec;ebpf;help;tui'= {
        }
        &'tracexec;ebpf;help;collect'= {
        }
        &'tracexec;ebpf;help;help'= {
        }
        &'tracexec;help'= {
            cand log 'Run tracexec in logging mode'
            cand tui 'Run tracexec in TUI mode, stdin/out/err are redirected to /dev/null by default'
            cand generate-completions 'Generate shell completions for tracexec'
            cand collect 'Collect exec events and export them'
            cand ebpf 'Experimental ebpf mode'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'tracexec;help;log'= {
        }
        &'tracexec;help;tui'= {
        }
        &'tracexec;help;generate-completions'= {
        }
        &'tracexec;help;collect'= {
        }
        &'tracexec;help;ebpf'= {
            cand log 'Run tracexec in logging mode'
            cand tui 'Run tracexec in TUI mode, stdin/out/err are redirected to /dev/null by default'
            cand collect 'Collect exec events and export them'
        }
        &'tracexec;help;ebpf;log'= {
        }
        &'tracexec;help;ebpf;tui'= {
        }
        &'tracexec;help;ebpf;collect'= {
        }
        &'tracexec;help;help'= {
        }
    ]
    $completions[$command]
}
