import { CancellationToken, Diagnostic } from 'vscode-languageserver';
import { Document } from '../../../lib/documents';
import { DiagnosticsProvider } from '../../interfaces';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
import { LSConfigManager } from '../../../ls-config';
export declare enum DiagnosticCode {
    MODIFIERS_CANNOT_APPEAR_HERE = 1184,// "Modifiers cannot appear here."
    USED_BEFORE_ASSIGNED = 2454,// "Variable '{0}' is used before being assigned."
    JSX_ELEMENT_DOES_NOT_SUPPORT_ATTRIBUTES = 2607,// "JSX element class does not support attributes because it does not have a '{0}' property."
    CANNOT_BE_USED_AS_JSX_COMPONENT = 2786,// "'{0}' cannot be used as a JSX component."
    NOOP_IN_COMMAS = 2695,// "Left side of comma operator is unused and has no side effects."
    NEVER_READ = 6133,// "'{0}' is declared but its value is never read."
    ALL_IMPORTS_UNUSED = 6192,// "All imports in import declaration are unused."
    UNUSED_LABEL = 7028,// "Unused label."
    DUPLICATED_JSX_ATTRIBUTES = 17001,// "JSX elements cannot have multiple attributes with the same name."
    DUPLICATE_IDENTIFIER = 2300,// "Duplicate identifier 'xxx'"
    MULTIPLE_PROPS_SAME_NAME = 1117,// "An object literal cannot have multiple properties with the same name in strict mode."
    ARG_TYPE_X_NOT_ASSIGNABLE_TO_TYPE_Y = 2345,// "Argument of type '..' is not assignable to parameter of type '..'."
    TYPE_X_NOT_ASSIGNABLE_TO_TYPE_Y = 2322,// "Type '..' is not assignable to type '..'."
    TYPE_X_NOT_ASSIGNABLE_TO_TYPE_Y_DID_YOU_MEAN = 2820,// "Type '..' is not assignable to type '..'. Did you mean '...'?"
    UNKNOWN_PROP = 2353,// "Object literal may only specify known properties, and '...' does not exist in type '...'"
    MISSING_PROPS = 2739,// "Type '...' is missing the following properties from type '..': ..."
    MISSING_PROP = 2741,// "Property '..' is missing in type '..' but required in type '..'."
    NO_OVERLOAD_MATCHES_CALL = 2769,// "No overload matches this call"
    CANNOT_FIND_NAME = 2304,// "Cannot find name 'xxx'"
    CANNOT_FIND_NAME_X_DID_YOU_MEAN_Y = 2552,// "Cannot find name '...' Did you mean '...'?"
    EXPECTED_N_ARGUMENTS = 2554,// Expected {0} arguments, but got {1}.
    DEPRECATED_SIGNATURE = 6387
}
export declare class DiagnosticsProviderImpl implements DiagnosticsProvider {
    private readonly lsAndTsDocResolver;
    private configManager;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, configManager: LSConfigManager);
    getDiagnostics(document: Document, cancellationToken?: CancellationToken): Promise<Diagnostic[]>;
    private getLSAndTSDoc;
}
