/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow;

import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.util.PythonUtils;
import sun.misc.Unsafe;

public class ArrowSchema {
    private static final Unsafe unsafe = PythonUtils.initUnsafe();
    private static final int SIZE_OF = 72;
    public static final byte[] CAPSULE_NAME = PyCapsule.capsuleName("arrow_schema");
    private static final byte NULL = 0;
    private static final long FORMAT_INDEX = 0L;
    private static final long NAME_INDEX = 8L;
    private static final long METADATA_INDEX = 16L;
    private static final long FLAGS_INDEX = 24L;
    private static final long N_CHILDREN_INDEX = 32L;
    private static final long CHILDREN_INDEX = 40L;
    private static final long DICTIONARY_INDEX = 48L;
    private static final long RELEASE_CALLBACK_INDEX = 56L;
    private static final long PRIVATE_DATA_INDEX = 64L;
    private final long memoryAddr;

    private ArrowSchema(long memoryAddr) {
        this.memoryAddr = memoryAddr;
    }

    public static ArrowSchema allocate(long format, long name, long metadata, long flags, long nChildren, long children, long dictionary, long release, long privateData) {
        long memoryAddr = unsafe.allocateMemory(72L);
        unsafe.putLong(memoryAddr + 0L, format);
        unsafe.putLong(memoryAddr + 8L, name);
        unsafe.putLong(memoryAddr + 16L, metadata);
        unsafe.putLong(memoryAddr + 24L, flags);
        unsafe.putLong(memoryAddr + 32L, nChildren);
        unsafe.putLong(memoryAddr + 40L, children);
        unsafe.putLong(memoryAddr + 48L, dictionary);
        unsafe.putLong(memoryAddr + 56L, release);
        unsafe.putLong(memoryAddr + 64L, privateData);
        return new ArrowSchema(memoryAddr);
    }

    public static ArrowSchema wrap(long arrowSchemaPointer) {
        return new ArrowSchema(arrowSchemaPointer);
    }

    public long memoryAddress() {
        return this.memoryAddr;
    }

    public long releaseCallback() {
        return unsafe.getLong(this.memoryAddr + 56L);
    }

    public boolean isReleased() {
        return this.releaseCallback() == 0L;
    }
}

