/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.re2j;

import org.apache.hadoop.shaded.com.google.re2j.Unicode;
import org.apache.hadoop.shaded.com.google.re2j.Utils;

class Inst {
    Op op;
    int out;
    int arg;
    int[] runes;

    Inst(Op op) {
        this.op = op;
    }

    Op op() {
        switch (this.op) {
            case RUNE1: 
            case RUNE_ANY: 
            case RUNE_ANY_NOT_NL: {
                return Op.RUNE;
            }
        }
        return this.op;
    }

    boolean matchRune(int r) {
        if (this.runes.length == 1) {
            int r0 = this.runes[0];
            if (r == r0) {
                return true;
            }
            if ((this.arg & 1) != 0) {
                int r1 = Unicode.simpleFold(r0);
                while (r1 != r0) {
                    if (r == r1) {
                        return true;
                    }
                    r1 = Unicode.simpleFold(r1);
                }
            }
            return false;
        }
        for (int j = 0; j < this.runes.length && j <= 8; j += 2) {
            if (r < this.runes[j]) {
                return false;
            }
            if (r > this.runes[j + 1]) continue;
            return true;
        }
        int lo = 0;
        int hi = this.runes.length / 2;
        while (lo < hi) {
            int m4 = lo + (hi - lo) / 2;
            int c = this.runes[2 * m4];
            if (c <= r) {
                if (r <= this.runes[2 * m4 + 1]) {
                    return true;
                }
                lo = m4 + 1;
                continue;
            }
            hi = m4;
        }
        return false;
    }

    public String toString() {
        switch (this.op) {
            case ALT: {
                return "alt -> " + this.out + ", " + this.arg;
            }
            case ALT_MATCH: {
                return "altmatch -> " + this.out + ", " + this.arg;
            }
            case CAPTURE: {
                return "cap " + this.arg + " -> " + this.out;
            }
            case EMPTY_WIDTH: {
                return "empty " + this.arg + " -> " + this.out;
            }
            case MATCH: {
                return "match";
            }
            case FAIL: {
                return "fail";
            }
            case NOP: {
                return "nop -> " + this.out;
            }
            case RUNE: {
                if (this.runes == null) {
                    return "rune <null>";
                }
                return "rune " + Inst.escapeRunes(this.runes) + ((this.arg & 1) != 0 ? "/i" : "") + " -> " + this.out;
            }
            case RUNE1: {
                return "rune1 " + Inst.escapeRunes(this.runes) + " -> " + this.out;
            }
            case RUNE_ANY: {
                return "any -> " + this.out;
            }
            case RUNE_ANY_NOT_NL: {
                return "anynotnl -> " + this.out;
            }
        }
        throw new IllegalStateException("unhandled case in Inst.toString");
    }

    private static String escapeRunes(int[] runes) {
        StringBuilder out = new StringBuilder();
        out.append('\"');
        for (int rune : runes) {
            Utils.escapeRune(out, rune);
        }
        out.append('\"');
        return out.toString();
    }

    static enum Op {
        ALT,
        ALT_MATCH,
        CAPTURE,
        EMPTY_WIDTH,
        FAIL,
        MATCH,
        NOP,
        RUNE,
        RUNE1,
        RUNE_ANY,
        RUNE_ANY_NOT_NL;

    }
}

