/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.collectors;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.performanceanalyzer.commons.OSMetricsGeneratorFactory;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.TCPStatus;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.metrics_generator.OSMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.metrics_generator.TCPMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;

public class NetworkE2ECollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    private static final int sTimeInterval = MetricsConfiguration.CONFIG_MAP.get(NetworkE2ECollector.class).samplingInterval;

    public NetworkE2ECollector() {
        super(sTimeInterval, "NetworkE2ECollector", StatMetrics.NETWORK_E2E_COLLECTOR_EXECUTION_TIME, StatExceptionCode.NETWORK_COLLECTION_ERROR);
    }

    @Override
    public void collectMetrics(long startTime) {
        OSMetricsGenerator generator = OSMetricsGeneratorFactory.getInstance();
        if (generator == null) {
            return;
        }
        TCPMetricsGenerator tcpMetricsGenerator = generator.getTCPMetricsGenerator();
        tcpMetricsGenerator.addSample();
        this.saveMetricValues(this.getMetrics(tcpMetricsGenerator), startTime, new String[0]);
    }

    @Override
    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath(startTime, "tcp_metrics");
    }

    private Map<String, TCPStatus> getMetricsMap(TCPMetricsGenerator tcpMetricsGenerator) {
        HashMap<String, TCPStatus> map = new HashMap<String, TCPStatus>();
        for (String dest : tcpMetricsGenerator.getAllDestionationIps()) {
            TCPStatus tcpStatus = new TCPStatus(dest, tcpMetricsGenerator.getNumberOfFlows(dest), tcpMetricsGenerator.getTransmitQueueSize(dest), tcpMetricsGenerator.getReceiveQueueSize(dest), tcpMetricsGenerator.getCurrentLost(dest), tcpMetricsGenerator.getSendCongestionWindow(dest), tcpMetricsGenerator.getSlowStartThreshold(dest));
            map.put(dest, tcpStatus);
        }
        return map;
    }

    private String getMetrics(TCPMetricsGenerator tcpMetricsGenerator) {
        Map<String, TCPStatus> map = this.getMetricsMap(tcpMetricsGenerator);
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        for (TCPStatus tcpStatus : map.values()) {
            this.value.append(tcpStatus.serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        }
        return this.value.toString();
    }
}

