/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstance;

public class DescribeVerifiedAccessInstancesIterable
implements SdkIterable<DescribeVerifiedAccessInstancesResponse> {
    private final Ec2Client client;
    private final DescribeVerifiedAccessInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVerifiedAccessInstancesIterable(Ec2Client client, DescribeVerifiedAccessInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVerifiedAccessInstancesResponseFetcher();
    }

    public Iterator<DescribeVerifiedAccessInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VerifiedAccessInstance> verifiedAccessInstances() {
        Function<DescribeVerifiedAccessInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.verifiedAccessInstances() != null) {
                return response.verifiedAccessInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVerifiedAccessInstancesResponseFetcher
    implements SyncPageFetcher<DescribeVerifiedAccessInstancesResponse> {
        private DescribeVerifiedAccessInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVerifiedAccessInstancesResponse nextPage(DescribeVerifiedAccessInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessInstancesIterable.this.client.describeVerifiedAccessInstances(DescribeVerifiedAccessInstancesIterable.this.firstRequest);
            }
            return DescribeVerifiedAccessInstancesIterable.this.client.describeVerifiedAccessInstances((DescribeVerifiedAccessInstancesRequest)((Object)DescribeVerifiedAccessInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

