/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamPublicAddressAssociationStatus;
import software.amazon.awssdk.services.ec2.model.IpamPublicAddressAwsService;
import software.amazon.awssdk.services.ec2.model.IpamPublicAddressSecurityGroup;
import software.amazon.awssdk.services.ec2.model.IpamPublicAddressSecurityGroupListCopier;
import software.amazon.awssdk.services.ec2.model.IpamPublicAddressTags;
import software.amazon.awssdk.services.ec2.model.IpamPublicAddressType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamDiscoveredPublicAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamDiscoveredPublicAddress> {
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryId").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::ipamResourceDiscoveryId)).setter(IpamDiscoveredPublicAddress.setter(Builder::ipamResourceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryId").unmarshallLocationName("ipamResourceDiscoveryId").build()}).build();
    private static final SdkField<String> ADDRESS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressRegion").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::addressRegion)).setter(IpamDiscoveredPublicAddress.setter(Builder::addressRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressRegion").unmarshallLocationName("addressRegion").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::address)).setter(IpamDiscoveredPublicAddress.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").unmarshallLocationName("address").build()}).build();
    private static final SdkField<String> ADDRESS_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressOwnerId").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::addressOwnerId)).setter(IpamDiscoveredPublicAddress.setter(Builder::addressOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressOwnerId").unmarshallLocationName("addressOwnerId").build()}).build();
    private static final SdkField<String> ADDRESS_ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressAllocationId").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::addressAllocationId)).setter(IpamDiscoveredPublicAddress.setter(Builder::addressAllocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressAllocationId").unmarshallLocationName("addressAllocationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationStatus").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::associationStatusAsString)).setter(IpamDiscoveredPublicAddress.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").unmarshallLocationName("associationStatus").build()}).build();
    private static final SdkField<String> ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressType").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::addressTypeAsString)).setter(IpamDiscoveredPublicAddress.setter(Builder::addressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressType").unmarshallLocationName("addressType").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::serviceAsString)).setter(IpamDiscoveredPublicAddress.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").unmarshallLocationName("service").build()}).build();
    private static final SdkField<String> SERVICE_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceResource").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::serviceResource)).setter(IpamDiscoveredPublicAddress.setter(Builder::serviceResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceResource").unmarshallLocationName("serviceResource").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::vpcId)).setter(IpamDiscoveredPublicAddress.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::subnetId)).setter(IpamDiscoveredPublicAddress.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> PUBLIC_IPV4_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIpv4PoolId").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::publicIpv4PoolId)).setter(IpamDiscoveredPublicAddress.setter(Builder::publicIpv4PoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4PoolId").unmarshallLocationName("publicIpv4PoolId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::networkInterfaceId)).setter(IpamDiscoveredPublicAddress.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceDescription").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::networkInterfaceDescription)).setter(IpamDiscoveredPublicAddress.setter(Builder::networkInterfaceDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceDescription").unmarshallLocationName("networkInterfaceDescription").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::instanceId)).setter(IpamDiscoveredPublicAddress.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<IpamPublicAddressTags> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tags").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::tags)).setter(IpamDiscoveredPublicAddress.setter(Builder::tags)).constructor(IpamPublicAddressTags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("tags").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::networkBorderGroup)).setter(IpamDiscoveredPublicAddress.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("networkBorderGroup").build()}).build();
    private static final SdkField<List<IpamPublicAddressSecurityGroup>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::securityGroups)).setter(IpamDiscoveredPublicAddress.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupSet").unmarshallLocationName("securityGroupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPublicAddressSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(IpamDiscoveredPublicAddress.getter(IpamDiscoveredPublicAddress::sampleTime)).setter(IpamDiscoveredPublicAddress.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").unmarshallLocationName("sampleTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_RESOURCE_DISCOVERY_ID_FIELD, ADDRESS_REGION_FIELD, ADDRESS_FIELD, ADDRESS_OWNER_ID_FIELD, ADDRESS_ALLOCATION_ID_FIELD, ASSOCIATION_STATUS_FIELD, ADDRESS_TYPE_FIELD, SERVICE_FIELD, SERVICE_RESOURCE_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, PUBLIC_IPV4_POOL_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, NETWORK_INTERFACE_DESCRIPTION_FIELD, INSTANCE_ID_FIELD, TAGS_FIELD, NETWORK_BORDER_GROUP_FIELD, SECURITY_GROUPS_FIELD, SAMPLE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamDiscoveredPublicAddress.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ipamResourceDiscoveryId;
    private final String addressRegion;
    private final String address;
    private final String addressOwnerId;
    private final String addressAllocationId;
    private final String associationStatus;
    private final String addressType;
    private final String service;
    private final String serviceResource;
    private final String vpcId;
    private final String subnetId;
    private final String publicIpv4PoolId;
    private final String networkInterfaceId;
    private final String networkInterfaceDescription;
    private final String instanceId;
    private final IpamPublicAddressTags tags;
    private final String networkBorderGroup;
    private final List<IpamPublicAddressSecurityGroup> securityGroups;
    private final Instant sampleTime;

    private IpamDiscoveredPublicAddress(BuilderImpl builder) {
        this.ipamResourceDiscoveryId = builder.ipamResourceDiscoveryId;
        this.addressRegion = builder.addressRegion;
        this.address = builder.address;
        this.addressOwnerId = builder.addressOwnerId;
        this.addressAllocationId = builder.addressAllocationId;
        this.associationStatus = builder.associationStatus;
        this.addressType = builder.addressType;
        this.service = builder.service;
        this.serviceResource = builder.serviceResource;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.publicIpv4PoolId = builder.publicIpv4PoolId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkInterfaceDescription = builder.networkInterfaceDescription;
        this.instanceId = builder.instanceId;
        this.tags = builder.tags;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.securityGroups = builder.securityGroups;
        this.sampleTime = builder.sampleTime;
    }

    public final String ipamResourceDiscoveryId() {
        return this.ipamResourceDiscoveryId;
    }

    public final String addressRegion() {
        return this.addressRegion;
    }

    public final String address() {
        return this.address;
    }

    public final String addressOwnerId() {
        return this.addressOwnerId;
    }

    public final String addressAllocationId() {
        return this.addressAllocationId;
    }

    public final IpamPublicAddressAssociationStatus associationStatus() {
        return IpamPublicAddressAssociationStatus.fromValue(this.associationStatus);
    }

    public final String associationStatusAsString() {
        return this.associationStatus;
    }

    public final IpamPublicAddressType addressType() {
        return IpamPublicAddressType.fromValue(this.addressType);
    }

    public final String addressTypeAsString() {
        return this.addressType;
    }

    public final IpamPublicAddressAwsService service() {
        return IpamPublicAddressAwsService.fromValue(this.service);
    }

    public final String serviceAsString() {
        return this.service;
    }

    public final String serviceResource() {
        return this.serviceResource;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String publicIpv4PoolId() {
        return this.publicIpv4PoolId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String networkInterfaceDescription() {
        return this.networkInterfaceDescription;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final IpamPublicAddressTags tags() {
        return this.tags;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<IpamPublicAddressSecurityGroup> securityGroups() {
        return this.securityGroups;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressAllocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpv4PoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamDiscoveredPublicAddress)) {
            return false;
        }
        IpamDiscoveredPublicAddress other = (IpamDiscoveredPublicAddress)obj;
        return Objects.equals(this.ipamResourceDiscoveryId(), other.ipamResourceDiscoveryId()) && Objects.equals(this.addressRegion(), other.addressRegion()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.addressOwnerId(), other.addressOwnerId()) && Objects.equals(this.addressAllocationId(), other.addressAllocationId()) && Objects.equals(this.associationStatusAsString(), other.associationStatusAsString()) && Objects.equals(this.addressTypeAsString(), other.addressTypeAsString()) && Objects.equals(this.serviceAsString(), other.serviceAsString()) && Objects.equals(this.serviceResource(), other.serviceResource()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.publicIpv4PoolId(), other.publicIpv4PoolId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.networkInterfaceDescription(), other.networkInterfaceDescription()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sampleTime(), other.sampleTime());
    }

    public final String toString() {
        return ToString.builder((String)"IpamDiscoveredPublicAddress").add("IpamResourceDiscoveryId", (Object)this.ipamResourceDiscoveryId()).add("AddressRegion", (Object)this.addressRegion()).add("Address", (Object)this.address()).add("AddressOwnerId", (Object)this.addressOwnerId()).add("AddressAllocationId", (Object)this.addressAllocationId()).add("AssociationStatus", (Object)this.associationStatusAsString()).add("AddressType", (Object)this.addressTypeAsString()).add("Service", (Object)this.serviceAsString()).add("ServiceResource", (Object)this.serviceResource()).add("VpcId", (Object)this.vpcId()).add("SubnetId", (Object)this.subnetId()).add("PublicIpv4PoolId", (Object)this.publicIpv4PoolId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("NetworkInterfaceDescription", (Object)this.networkInterfaceDescription()).add("InstanceId", (Object)this.instanceId()).add("Tags", (Object)this.tags()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SampleTime", (Object)this.sampleTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamResourceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryId()));
            }
            case "AddressRegion": {
                return Optional.ofNullable(clazz.cast(this.addressRegion()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "AddressOwnerId": {
                return Optional.ofNullable(clazz.cast(this.addressOwnerId()));
            }
            case "AddressAllocationId": {
                return Optional.ofNullable(clazz.cast(this.addressAllocationId()));
            }
            case "AssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatusAsString()));
            }
            case "AddressType": {
                return Optional.ofNullable(clazz.cast(this.addressTypeAsString()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.serviceAsString()));
            }
            case "ServiceResource": {
                return Optional.ofNullable(clazz.cast(this.serviceResource()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "PublicIpv4PoolId": {
                return Optional.ofNullable(clazz.cast(this.publicIpv4PoolId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "NetworkInterfaceDescription": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceDescription()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IpamResourceDiscoveryId", IPAM_RESOURCE_DISCOVERY_ID_FIELD);
        map.put("AddressRegion", ADDRESS_REGION_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("AddressOwnerId", ADDRESS_OWNER_ID_FIELD);
        map.put("AddressAllocationId", ADDRESS_ALLOCATION_ID_FIELD);
        map.put("AssociationStatus", ASSOCIATION_STATUS_FIELD);
        map.put("AddressType", ADDRESS_TYPE_FIELD);
        map.put("Service", SERVICE_FIELD);
        map.put("ServiceResource", SERVICE_RESOURCE_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("PublicIpv4PoolId", PUBLIC_IPV4_POOL_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("NetworkInterfaceDescription", NETWORK_INTERFACE_DESCRIPTION_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
        map.put("SecurityGroupSet", SECURITY_GROUPS_FIELD);
        map.put("SampleTime", SAMPLE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamDiscoveredPublicAddress, T> g) {
        return obj -> g.apply((IpamDiscoveredPublicAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipamResourceDiscoveryId;
        private String addressRegion;
        private String address;
        private String addressOwnerId;
        private String addressAllocationId;
        private String associationStatus;
        private String addressType;
        private String service;
        private String serviceResource;
        private String vpcId;
        private String subnetId;
        private String publicIpv4PoolId;
        private String networkInterfaceId;
        private String networkInterfaceDescription;
        private String instanceId;
        private IpamPublicAddressTags tags;
        private String networkBorderGroup;
        private List<IpamPublicAddressSecurityGroup> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private Instant sampleTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamDiscoveredPublicAddress model) {
            this.ipamResourceDiscoveryId(model.ipamResourceDiscoveryId);
            this.addressRegion(model.addressRegion);
            this.address(model.address);
            this.addressOwnerId(model.addressOwnerId);
            this.addressAllocationId(model.addressAllocationId);
            this.associationStatus(model.associationStatus);
            this.addressType(model.addressType);
            this.service(model.service);
            this.serviceResource(model.serviceResource);
            this.vpcId(model.vpcId);
            this.subnetId(model.subnetId);
            this.publicIpv4PoolId(model.publicIpv4PoolId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.networkInterfaceDescription(model.networkInterfaceDescription);
            this.instanceId(model.instanceId);
            this.tags(model.tags);
            this.networkBorderGroup(model.networkBorderGroup);
            this.securityGroups(model.securityGroups);
            this.sampleTime(model.sampleTime);
        }

        public final String getIpamResourceDiscoveryId() {
            return this.ipamResourceDiscoveryId;
        }

        public final void setIpamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
        }

        @Override
        public final Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
            return this;
        }

        public final String getAddressRegion() {
            return this.addressRegion;
        }

        public final void setAddressRegion(String addressRegion) {
            this.addressRegion = addressRegion;
        }

        @Override
        public final Builder addressRegion(String addressRegion) {
            this.addressRegion = addressRegion;
            return this;
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getAddressOwnerId() {
            return this.addressOwnerId;
        }

        public final void setAddressOwnerId(String addressOwnerId) {
            this.addressOwnerId = addressOwnerId;
        }

        @Override
        public final Builder addressOwnerId(String addressOwnerId) {
            this.addressOwnerId = addressOwnerId;
            return this;
        }

        public final String getAddressAllocationId() {
            return this.addressAllocationId;
        }

        public final void setAddressAllocationId(String addressAllocationId) {
            this.addressAllocationId = addressAllocationId;
        }

        @Override
        public final Builder addressAllocationId(String addressAllocationId) {
            this.addressAllocationId = addressAllocationId;
            return this;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(IpamPublicAddressAssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getAddressType() {
            return this.addressType;
        }

        public final void setAddressType(String addressType) {
            this.addressType = addressType;
        }

        @Override
        public final Builder addressType(String addressType) {
            this.addressType = addressType;
            return this;
        }

        @Override
        public final Builder addressType(IpamPublicAddressType addressType) {
            this.addressType(addressType == null ? null : addressType.toString());
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(IpamPublicAddressAwsService service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        public final String getServiceResource() {
            return this.serviceResource;
        }

        public final void setServiceResource(String serviceResource) {
            this.serviceResource = serviceResource;
        }

        @Override
        public final Builder serviceResource(String serviceResource) {
            this.serviceResource = serviceResource;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getPublicIpv4PoolId() {
            return this.publicIpv4PoolId;
        }

        public final void setPublicIpv4PoolId(String publicIpv4PoolId) {
            this.publicIpv4PoolId = publicIpv4PoolId;
        }

        @Override
        public final Builder publicIpv4PoolId(String publicIpv4PoolId) {
            this.publicIpv4PoolId = publicIpv4PoolId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getNetworkInterfaceDescription() {
            return this.networkInterfaceDescription;
        }

        public final void setNetworkInterfaceDescription(String networkInterfaceDescription) {
            this.networkInterfaceDescription = networkInterfaceDescription;
        }

        @Override
        public final Builder networkInterfaceDescription(String networkInterfaceDescription) {
            this.networkInterfaceDescription = networkInterfaceDescription;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final IpamPublicAddressTags.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        public final void setTags(IpamPublicAddressTags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(IpamPublicAddressTags tags) {
            this.tags = tags;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final List<IpamPublicAddressSecurityGroup.Builder> getSecurityGroups() {
            List<IpamPublicAddressSecurityGroup.Builder> result = IpamPublicAddressSecurityGroupListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<IpamPublicAddressSecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = IpamPublicAddressSecurityGroupListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<IpamPublicAddressSecurityGroup> securityGroups) {
            this.securityGroups = IpamPublicAddressSecurityGroupListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(IpamPublicAddressSecurityGroup ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<IpamPublicAddressSecurityGroup.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (IpamPublicAddressSecurityGroup)((IpamPublicAddressSecurityGroup.Builder)IpamPublicAddressSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public IpamDiscoveredPublicAddress build() {
            return new IpamDiscoveredPublicAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamDiscoveredPublicAddress> {
        public Builder ipamResourceDiscoveryId(String var1);

        public Builder addressRegion(String var1);

        public Builder address(String var1);

        public Builder addressOwnerId(String var1);

        public Builder addressAllocationId(String var1);

        public Builder associationStatus(String var1);

        public Builder associationStatus(IpamPublicAddressAssociationStatus var1);

        public Builder addressType(String var1);

        public Builder addressType(IpamPublicAddressType var1);

        public Builder service(String var1);

        public Builder service(IpamPublicAddressAwsService var1);

        public Builder serviceResource(String var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder publicIpv4PoolId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder networkInterfaceDescription(String var1);

        public Builder instanceId(String var1);

        public Builder tags(IpamPublicAddressTags var1);

        default public Builder tags(Consumer<IpamPublicAddressTags.Builder> tags) {
            return this.tags((IpamPublicAddressTags)((IpamPublicAddressTags.Builder)IpamPublicAddressTags.builder().applyMutation(tags)).build());
        }

        public Builder networkBorderGroup(String var1);

        public Builder securityGroups(Collection<IpamPublicAddressSecurityGroup> var1);

        public Builder securityGroups(IpamPublicAddressSecurityGroup ... var1);

        public Builder securityGroups(Consumer<IpamPublicAddressSecurityGroup.Builder> ... var1);

        public Builder sampleTime(Instant var1);
    }
}

