"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.monaco = void 0;
const tslib_1 = require("tslib");
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/* eslint-disable @osd/eslint/module_migration */
// Import the monaco-editor package directly
const monaco = tslib_1.__importStar(require("monaco-editor/esm/vs/editor/editor.api"));
exports.monaco = monaco;
// Import CSS for Monaco editor icons
require("monaco-editor/min/vs/editor/editor.main.css");
// Import worker-related modules
require("monaco-editor/esm/vs/base/common/worker/simpleWorker");
require("monaco-editor/esm/vs/editor/browser/services/editorWorkerService");
// Import core editor functionality
require("monaco-editor/esm/vs/editor/browser/coreCommands");
require("monaco-editor/esm/vs/editor/browser/widget/codeEditor/codeEditorWidget");
// Import editor features
require("monaco-editor/esm/vs/editor/contrib/wordOperations/browser/wordOperations"); // For word-wise char navigation
require("monaco-editor/esm/vs/editor/contrib/suggest/browser/suggestController"); // For autocomplete
require("monaco-editor/esm/vs/editor/contrib/hover/browser/hoverContribution"); // For hover
require("monaco-editor/esm/vs/editor/contrib/parameterHints/browser/parameterHints"); // For parameter hints
//# sourceMappingURL=monaco.js.map