/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.HeapCompactSketch;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.SingleItemSketch;
import com.yahoo.sketches.theta.UpdateSketch;

final class HeapCompactOrderedSketch
extends HeapCompactSketch {
    private HeapCompactOrderedSketch(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong) {
        super(cache, empty, seedHash, curCount, thetaLong);
    }

    static CompactSketch heapifyInstance(Memory srcMem, long seed) {
        short memSeedHash = (short)PreambleUtil.extractSeedHash(srcMem);
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        boolean empty = PreambleUtil.isEmpty(srcMem);
        int curCount = 0;
        long thetaLong = Long.MAX_VALUE;
        long[] cache = new long[]{};
        if (preLongs == 1) {
            if (!empty) {
                return new SingleItemSketch(srcMem.getLong(8L), memSeedHash);
            }
        } else {
            curCount = PreambleUtil.extractCurCount(srcMem);
            cache = new long[curCount];
            if (preLongs == 2) {
                srcMem.getLongArray(16L, cache, 0, curCount);
            } else {
                srcMem.getLongArray(24L, cache, 0, curCount);
                thetaLong = PreambleUtil.extractThetaLong(srcMem);
            }
        }
        return new HeapCompactOrderedSketch(cache, empty, memSeedHash, curCount, thetaLong);
    }

    static CompactSketch compact(UpdateSketch sketch) {
        int curCount = sketch.getRetainedEntries(true);
        long thetaLong = sketch.getThetaLong();
        boolean empty = sketch.isEmpty();
        thetaLong = HeapCompactOrderedSketch.thetaOnCompact(empty, curCount, thetaLong);
        empty = HeapCompactOrderedSketch.emptyOnCompact(curCount, thetaLong);
        short seedHash = sketch.getSeedHash();
        long[] cache = sketch.getCache();
        boolean ordered = true;
        long[] cacheOut = CompactSketch.compactCache(cache, curCount, thetaLong, true);
        if (curCount == 1 && thetaLong == Long.MAX_VALUE) {
            return new SingleItemSketch(cacheOut[0], seedHash);
        }
        return new HeapCompactOrderedSketch(cacheOut, empty, seedHash, curCount, thetaLong);
    }

    static CompactSketch compact(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong) {
        if (curCount == 1 && thetaLong == Long.MAX_VALUE) {
            return new SingleItemSketch(cache[0], seedHash);
        }
        return new HeapCompactOrderedSketch(cache, empty, seedHash, curCount, thetaLong);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(true);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

