/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.util;

import com.amazon.randomcutforest.CommonUtils;

public class ShingleBuilder {
    private final int dimensions;
    private final int shingleSize;
    private final double[][] recentPoints;
    private final boolean cyclic;
    private int shingleIndex;
    private boolean full;

    public ShingleBuilder(int dimensions, int shingleSize, boolean cyclic) {
        CommonUtils.checkArgument(dimensions > 0, "dimensions must be greater than 0");
        CommonUtils.checkArgument(shingleSize > 0, "shingleSize must be greater than 0");
        this.dimensions = dimensions;
        this.shingleSize = shingleSize;
        this.cyclic = cyclic;
        this.recentPoints = new double[shingleSize][dimensions];
        this.shingleIndex = 0;
        this.full = false;
    }

    public ShingleBuilder(int dimensions, int shingleSize) {
        this(dimensions, shingleSize, false);
    }

    public boolean isFull() {
        return this.full;
    }

    public int getInputPointSize() {
        return this.dimensions;
    }

    public int getShingledPointSize() {
        return this.dimensions * this.shingleSize;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public int getShingleIndex() {
        return this.shingleIndex;
    }

    public void addPoint(double[] point) {
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkArgument(point.length == this.dimensions, String.format("point.length must equal %d", this.dimensions));
        System.arraycopy(point, 0, this.recentPoints[this.shingleIndex], 0, this.dimensions);
        this.shingleIndex = (this.shingleIndex + 1) % this.shingleSize;
        if (!this.full && this.shingleIndex == 0) {
            this.full = true;
        }
    }

    public double[] getShingle() {
        double[] shingle = new double[this.shingleSize * this.dimensions];
        this.getShingle(shingle);
        return shingle;
    }

    public void getShingle(double[] shingle) {
        CommonUtils.checkNotNull(shingle, "shingle must not be null");
        CommonUtils.checkArgument(shingle.length == this.dimensions * this.shingleSize, "shingle.length must be dimensions * shingleSize");
        int beginIndex = this.cyclic ? 0 : this.shingleIndex;
        for (int i = 0; i < this.shingleSize; ++i) {
            System.arraycopy(this.recentPoints[(beginIndex + i) % this.shingleSize], 0, shingle, i * this.dimensions, this.dimensions);
        }
    }
}

