/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.simplify.VWLineSimplifier;

public class VWSimplifier {
    private Geometry inputGeom;
    private double distanceTolerance;
    private boolean isEnsureValidTopology = true;

    public static Geometry simplify(Geometry geom, double distanceTolerance) {
        VWSimplifier simp = new VWSimplifier(geom);
        simp.setDistanceTolerance(distanceTolerance);
        return simp.getResultGeometry();
    }

    public VWSimplifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public void setEnsureValid(boolean isEnsureValidTopology) {
        this.isEnsureValidTopology = isEnsureValidTopology;
    }

    public Geometry getResultGeometry() {
        if (this.inputGeom.isEmpty()) {
            return this.inputGeom.copy();
        }
        return new VWTransformer(this.isEnsureValidTopology, this.distanceTolerance).transform(this.inputGeom);
    }

    static class VWTransformer
    extends GeometryTransformer {
        private boolean isEnsureValidTopology = true;
        private double distanceTolerance;

        public VWTransformer(boolean isEnsureValidTopology, double distanceTolerance) {
            this.isEnsureValidTopology = isEnsureValidTopology;
            this.distanceTolerance = distanceTolerance;
        }

        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            Coordinate[] inputPts = coords.toCoordinateArray();
            Coordinate[] newPts = null;
            newPts = inputPts.length == 0 ? new Coordinate[]{} : VWLineSimplifier.simplify(inputPts, this.distanceTolerance);
            return this.factory.getCoordinateSequenceFactory().create(newPts);
        }

        protected Geometry transformPolygon(Polygon geom, Geometry parent) {
            if (geom.isEmpty()) {
                return null;
            }
            Geometry rawGeom = super.transformPolygon(geom, parent);
            if (parent instanceof MultiPolygon) {
                return rawGeom;
            }
            return this.createValidArea(rawGeom);
        }

        protected Geometry transformLinearRing(LinearRing geom, Geometry parent) {
            boolean removeDegenerateRings = parent instanceof Polygon;
            Geometry simpResult = super.transformLinearRing(geom, parent);
            if (removeDegenerateRings && !(simpResult instanceof LinearRing)) {
                return null;
            }
            return simpResult;
        }

        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
            Geometry rawGeom = super.transformMultiPolygon(geom, parent);
            return this.createValidArea(rawGeom);
        }

        private Geometry createValidArea(Geometry rawAreaGeom) {
            if (this.isEnsureValidTopology) {
                return rawAreaGeom.buffer(0.0);
            }
            return rawAreaGeom;
        }
    }
}

