/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.search.Query;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryCoordinatorContext;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;

public class TemplateQueryBuilder
extends AbstractQueryBuilder<TemplateQueryBuilder> {
    public static final String NAME = "template";
    public static final String queryName = "template";
    private final Map<String, Object> content;

    public TemplateQueryBuilder(Map<String, Object> content) {
        this.content = content;
    }

    public static TemplateQueryBuilder fromXContent(XContentParser parser) throws IOException {
        return new TemplateQueryBuilder(parser.map());
    }

    public TemplateQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.content = in.readMap();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeMap(this.content);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("template", this.content);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new IllegalStateException("Template queries cannot be converted directly to a query. Template Query must be rewritten first during doRewrite.");
    }

    @Override
    protected boolean doEquals(TemplateQueryBuilder other) {
        return Objects.equals(this.content, other.content);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.content);
    }

    public String getWriteableName() {
        return "template";
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryCoordinatorContext) throws IOException {
        String queryString;
        if (!(queryCoordinatorContext instanceof QueryCoordinatorContext)) {
            throw new IllegalStateException("Template Query must be rewritten at the coordinator node. Rewriting at shard level is not supported.");
        }
        QueryCoordinatorContext convertedQueryCoordinateContext = (QueryCoordinatorContext)queryCoordinatorContext;
        Map<String, Object> contextVariables = convertedQueryCoordinateContext.getContextVariables();
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.map(this.content);
            queryString = builder.toString();
        }
        Map<String, String> variablesMap = null;
        if (contextVariables != null) {
            variablesMap = contextVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                try {
                    return JsonXContent.contentBuilder().value(entry.getValue()).toString();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error converting contextVariables to JSON string", e);
                }
            }));
        }
        String newQueryContent = this.replaceVariables(queryString, variablesMap);
        try {
            XContentParser parser = XContentType.JSON.xContent().createParser(queryCoordinatorContext.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, newQueryContent);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            QueryBuilder newQueryBuilder = TemplateQueryBuilder.parseInnerQueryBuilder(parser);
            return newQueryBuilder;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to rewrite template query: " + newQueryContent, e);
        }
    }

    private String replaceVariables(String template, Map<String, String> variables) {
        if (template == null || template.equals("null")) {
            throw new IllegalArgumentException("Template string cannot be null. A valid template must be provided.");
        }
        if (template.isEmpty() || template.equals("{}")) {
            throw new IllegalArgumentException("Template string cannot be empty. A valid template must be provided.");
        }
        if (variables == null || variables.isEmpty()) {
            return template;
        }
        StringBuilder result = new StringBuilder();
        int start = 0;
        while (true) {
            int startVar;
            if ((startVar = template.indexOf("\"${", start)) == -1) break;
            result.append(template, start, startVar);
            int endVar = template.indexOf("}\"", startVar);
            if (endVar == -1) {
                throw new IllegalArgumentException("Unclosed variable in template: " + template.substring(startVar));
            }
            String varName = template.substring(startVar + 3, endVar);
            String replacement = variables.get(varName);
            if (replacement == null) {
                throw new IllegalArgumentException("Variable not found: " + varName);
            }
            result.append(replacement);
            start = endVar + 2;
        }
        result.append(template.substring(start));
        return result.toString();
    }
}

