/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Numbers;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.hash.T1ha1;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.LongArray;
import org.opensearch.core.common.util.ByteArray;

@InternalApi
public final class BytesRefHash
implements Releasable {
    private static final long MAX_CAPACITY = 0x100000000L;
    private static final long DEFAULT_INITIAL_CAPACITY = 32L;
    private static final float DEFAULT_LOAD_FACTOR = 0.6f;
    private static final Hasher DEFAULT_HASHER = key -> T1ha1.hash((byte[])key.bytes, (int)key.offset, (int)key.length);
    private static final long MASK_ORDINAL = 0xFFFFFFFFL;
    private static final long MASK_FINGERPRINT = -4294967296L;
    private final float loadFactor;
    private final Hasher hasher;
    private final BigArrays bigArrays;
    private final BytesRef scratch = new BytesRef();
    private long capacity;
    private long mask;
    private long grow;
    private long size;
    private LongArray table;
    private LongArray offsets;
    private ByteArray keys;
    private LongArray hashes;

    public BytesRefHash(BigArrays bigArrays) {
        this(32L, 0.6f, DEFAULT_HASHER, bigArrays);
    }

    public BytesRefHash(long initialCapacity, BigArrays bigArrays) {
        this(initialCapacity, 0.6f, DEFAULT_HASHER, bigArrays);
    }

    public BytesRefHash(long initialCapacity, float loadFactor, BigArrays bigArrays) {
        this(initialCapacity, loadFactor, DEFAULT_HASHER, bigArrays);
    }

    public BytesRefHash(long initialCapacity, float loadFactor, Hasher hasher, BigArrays bigArrays) {
        assert (initialCapacity > 0L) : "initial capacity must be greater than 0";
        assert (loadFactor > 0.0f && loadFactor < 1.0f) : "load factor must be between 0 and 1";
        this.loadFactor = loadFactor;
        this.hasher = hasher;
        this.bigArrays = bigArrays;
        this.capacity = Numbers.nextPowerOfTwo((long)((long)((float)initialCapacity / loadFactor)));
        assert (this.capacity <= 0x100000000L) : "required capacity too large";
        this.mask = this.capacity - 1L;
        this.size = 0L;
        this.grow = (long)((float)this.capacity * loadFactor);
        this.table = bigArrays.newLongArray(this.capacity, false);
        this.table.fill(0L, this.capacity, -1L);
        this.offsets = bigArrays.newLongArray(initialCapacity + 1L, false);
        this.offsets.set(0L, 0L);
        this.keys = bigArrays.newByteArray(initialCapacity * 3L, false);
        this.hashes = bigArrays.newLongArray(initialCapacity, false);
    }

    public long add(BytesRef key) {
        long hash = this.hasher.hash(key);
        long fingerprint = hash & 0xFFFFFFFF00000000L;
        long idx = hash & this.mask;
        while (true) {
            long ordinal;
            long value;
            if ((value = this.table.get(idx)) == -1L) {
                long val = fingerprint | this.size;
                if (this.size >= this.grow) {
                    this.growAndInsert(hash, val);
                } else {
                    this.table.set(idx, val);
                }
                return this.append(key, hash);
            }
            if ((value & 0xFFFFFFFF00000000L) == fingerprint && key.bytesEquals(this.get(ordinal = value & 0xFFFFFFFFL, this.scratch))) {
                return -1L - ordinal;
            }
            idx = idx + 1L & this.mask;
        }
    }

    public long find(BytesRef key) {
        long hash = this.hasher.hash(key);
        long fingerprint = hash & 0xFFFFFFFF00000000L;
        long idx = hash & this.mask;
        long value;
        while ((value = this.table.get(idx)) != -1L) {
            long ordinal;
            if ((value & 0xFFFFFFFF00000000L) == fingerprint && key.bytesEquals(this.get(ordinal = value & 0xFFFFFFFFL, this.scratch))) {
                return ordinal;
            }
            idx = idx + 1L & this.mask;
        }
        return -1L;
    }

    public BytesRef get(long ordinal, BytesRef dest) {
        long start = this.offsets.get(ordinal);
        int length = (int)(this.offsets.get(ordinal + 1L) - start);
        this.keys.get(start, length, dest);
        return dest;
    }

    public long size() {
        return this.size;
    }

    private long append(BytesRef key, long hash) {
        long start = this.offsets.get(this.size);
        long end = start + (long)key.length;
        this.offsets = this.bigArrays.grow(this.offsets, this.size + 2L);
        this.offsets.set(this.size + 1L, end);
        this.keys = this.bigArrays.grow(this.keys, end);
        this.keys.set(start, key.bytes, key.offset, key.length);
        this.hashes = this.bigArrays.grow(this.hashes, this.size + 1L);
        this.hashes.set(this.size, hash);
        return this.size++;
    }

    private void growAndInsert(long hash, long value) {
        assert (this.capacity < 0x100000000L) : "hash table already at the max capacity";
        this.capacity <<= 1;
        this.mask = this.capacity - 1L;
        this.grow = (long)((float)this.capacity * this.loadFactor);
        this.table = this.bigArrays.grow(this.table, this.capacity);
        this.table.fill(0L, this.capacity, -1L);
        this.table.set(hash & this.mask, value);
        for (long ordinal = 0L; ordinal < this.size; ++ordinal) {
            this.reinsert(ordinal, this.hashes.get(ordinal));
        }
    }

    private void reinsert(long ordinal, long hash) {
        long idx = hash & this.mask;
        while (true) {
            if (this.table.get(idx) == -1L) {
                this.table.set(idx, hash & 0xFFFFFFFF00000000L | ordinal);
                return;
            }
            idx = idx + 1L & this.mask;
        }
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.table, this.offsets, this.keys, this.hashes});
    }

    @FunctionalInterface
    public static interface Hasher {
        public long hash(BytesRef var1);
    }
}

