/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.logging;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.opensearch.core.common.Strings;

@Plugin(name="OpenSearchJsonLayout", category="Core", elementType="layout", printObject=true)
public class OpenSearchJsonLayout
extends AbstractStringLayout {
    private final PatternLayout patternLayout;

    protected OpenSearchJsonLayout(String typeName, Charset charset, String[] opensearchMessageFields, int maxMessageLength, Configuration configuration) {
        super(charset);
        this.patternLayout = PatternLayout.newBuilder().withPattern(this.pattern(typeName, opensearchMessageFields, maxMessageLength)).withAlwaysWriteExceptions(false).withConfiguration(configuration).build();
    }

    private String pattern(String type, String[] opensearchMessageFields, int maxMessageLength) {
        if (Strings.isEmpty((CharSequence)type)) {
            throw new IllegalArgumentException("layout parameter 'type_name' cannot be empty");
        }
        Object messageFormat = "%m";
        if (maxMessageLength < 0) {
            throw new IllegalArgumentException("layout parameter 'maxmessagelength' cannot be a negative number");
        }
        if (maxMessageLength > 0) {
            messageFormat = "%.-" + Integer.toString(maxMessageLength) + "m";
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", this.inQuotes(type));
        map.put("timestamp", this.inQuotes("%d{yyyy-MM-dd'T'HH:mm:ss,SSSZZ}"));
        map.put("level", this.inQuotes("%p"));
        map.put("component", this.inQuotes("%c{1.}"));
        map.put("cluster.name", this.inQuotes("${sys:opensearch.logs.cluster_name}"));
        map.put("node.name", this.inQuotes("%node_name"));
        map.put("message", this.inQuotes("%notEmpty{%enc{%marker}{JSON} }%enc{" + (String)messageFormat + "}{JSON}"));
        for (String key : opensearchMessageFields) {
            map.put(key, this.inQuotes("%OpenSearchMessageField{" + key + "}"));
        }
        return this.createPattern(map, Stream.of(opensearchMessageFields).collect(Collectors.toSet()));
    }

    private String createPattern(Map<String, Object> map, Set<String> opensearchMessageFields) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String separator = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (opensearchMessageFields.contains(entry.getKey())) {
                sb.append("%notEmpty{");
                sb.append(separator);
                this.appendField(sb, entry);
                sb.append("}");
            } else {
                sb.append(separator);
                this.appendField(sb, entry);
            }
            separator = ", ";
        }
        sb.append(this.notEmpty(", %node_and_cluster_id "));
        sb.append("%exceptionAsJson ");
        sb.append("}");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private void appendField(StringBuilder sb, Map.Entry<String, Object> entry) {
        sb.append(this.jsonKey(entry.getKey()));
        sb.append(entry.getValue().toString());
    }

    private String notEmpty(String value) {
        return "%notEmpty{" + value + "}";
    }

    private CharSequence jsonKey(String s) {
        return this.inQuotes(s) + ": ";
    }

    private String inQuotes(String s) {
        return "\"" + s + "\"";
    }

    @PluginFactory
    public static OpenSearchJsonLayout createLayout(String type, Charset charset, String[] opensearchmessagefields, int maxMessageLength, Configuration configuration) {
        return new OpenSearchJsonLayout(type, charset, opensearchmessagefields, maxMessageLength, configuration);
    }

    PatternLayout getPatternLayout() {
        return this.patternLayout;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public String toSerializable(LogEvent event) {
        return this.patternLayout.toSerializable(event);
    }

    public Map<String, String> getContentFormat() {
        return this.patternLayout.getContentFormat();
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        this.patternLayout.encode(event, destination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSearchJsonLayout{");
        sb.append("patternLayout=").append(this.patternLayout);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<OpenSearchJsonLayout> {
        @PluginAttribute(value="type_name")
        String type;
        @PluginAttribute(value="charset", defaultString="UTF-8")
        Charset charset;
        @PluginAttribute(value="opensearchmessagefields")
        private String opensearchMessageFields;
        @PluginAttribute(value="maxmessagelength", defaultInt=10000)
        private int maxMessageLength;
        @PluginConfiguration
        private Configuration configuration;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
            this.setMaxMessageLength(10000);
        }

        public OpenSearchJsonLayout build() {
            String[] split = Strings.isNullOrEmpty((String)this.opensearchMessageFields) ? new String[]{} : this.opensearchMessageFields.split(",");
            return OpenSearchJsonLayout.createLayout(this.type, this.charset, split, this.maxMessageLength, this.configuration);
        }

        public Charset getCharset() {
            return this.charset;
        }

        public B setCharset(Charset charset) {
            this.charset = charset;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getType() {
            return this.type;
        }

        public B setType(String type) {
            this.type = type;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getOpenSearchMessageFields() {
            return this.opensearchMessageFields;
        }

        public B setOpenSearchMessageFields(String opensearchMessageFields) {
            this.opensearchMessageFields = opensearchMessageFields;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public int getMaxMessageLength() {
            return this.maxMessageLength;
        }

        public B setMaxMessageLength(int maxMessageLength) {
            this.maxMessageLength = maxMessageLength;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public B setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

