/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.service;

import java.util.Map;
import org.opensearch.cluster.ClusterManagerMetrics;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateTaskExecutor;
import org.opensearch.cluster.ClusterStateTaskListener;
import org.opensearch.cluster.coordination.ClusterStatePublisher;
import org.opensearch.cluster.service.ClusterApplierService;
import org.opensearch.cluster.service.ClusterManagerService;
import org.opensearch.cluster.service.ClusterManagerTask;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterManagerThrottlingStats;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.node.Node;
import org.opensearch.threadpool.ThreadPool;

public class LocalClusterService
extends ClusterService {
    public LocalClusterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, ClusterManagerMetrics clusterManagerMetrics) {
        super(settings, clusterSettings, new DummyClusterManagerService(settings, clusterSettings), new ClusterApplierService(Node.NODE_NAME_SETTING.get(settings), settings, clusterSettings, threadPool, clusterManagerMetrics));
    }

    @Override
    protected synchronized void doStart() {
        this.getClusterApplierService().start();
    }

    @Override
    protected synchronized void doStop() {
        this.getClusterApplierService().stop();
    }

    @Override
    protected synchronized void doClose() {
        this.getClusterApplierService().close();
    }

    @Override
    public ClusterManagerTaskThrottler.ThrottlingKey registerClusterManagerTask(ClusterManagerTask task, boolean throttlingEnabled) {
        return null;
    }

    @Override
    public <T> void submitStateUpdateTasks(String source, Map<T, ClusterStateTaskListener> tasks, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor) {
        throw new UnsupportedOperationException("Cannot submit cluster state update tasks when cluster manager service is not available");
    }

    private static class DummyClusterManagerService
    extends ClusterManagerService {
        private static final ClusterManagerThrottlingStats EMPTY_THROTTLING_STATS = new ClusterManagerThrottlingStats();

        public DummyClusterManagerService(Settings settings, ClusterSettings clusterSettings) {
            super(settings, clusterSettings, null, null);
        }

        @Override
        public synchronized void setClusterStatePublisher(ClusterStatePublisher publisher) {
        }

        @Override
        public ClusterManagerThrottlingStats getThrottlingStats() {
            return EMPTY_THROTTLING_STATS;
        }
    }
}

