/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.transport.TransportRequest;

public class PreVoteRequest
extends TransportRequest {
    private final DiscoveryNode sourceNode;
    private final long currentTerm;

    public PreVoteRequest(DiscoveryNode sourceNode, long currentTerm) {
        this.sourceNode = sourceNode;
        this.currentTerm = currentTerm;
    }

    public PreVoteRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceNode = new DiscoveryNode(in);
        this.currentTerm = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceNode.writeTo(out);
        out.writeLong(this.currentTerm);
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public String toString() {
        return "PreVoteRequest{sourceNode=" + String.valueOf(this.sourceNode) + ", currentTerm=" + this.currentTerm + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreVoteRequest that = (PreVoteRequest)o;
        return this.currentTerm == that.currentTerm && Objects.equals(this.sourceNode, that.sourceNode);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNode, this.currentTerm);
    }
}

