/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.snapshots.create;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchGenerationException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class CreateSnapshotRequest
extends ClusterManagerNodeRequest<CreateSnapshotRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    public static int MAXIMUM_METADATA_BYTES = 1024;
    private String snapshot;
    private String repository;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenHidden();
    private boolean partial = false;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private boolean includeGlobalState = true;
    private boolean waitForCompletion;
    private Map<String, Object> userMetadata;

    public CreateSnapshotRequest() {
    }

    public CreateSnapshotRequest(String repository, String snapshot) {
        this.snapshot = snapshot;
        this.repository = repository;
    }

    public CreateSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.settings = Settings.readSettingsFromStream(in);
        this.includeGlobalState = in.readBoolean();
        this.waitForCompletion = in.readBoolean();
        this.partial = in.readBoolean();
        this.userMetadata = in.readMap();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeBoolean(this.includeGlobalState);
        out.writeBoolean(this.waitForCompletion);
        out.writeBoolean(this.partial);
        out.writeMap(this.userMetadata);
    }

    @Override
    public ActionRequestValidationException validate() {
        int metadataSize;
        ActionRequestValidationException validationException = null;
        if (this.snapshot == null) {
            validationException = ValidateActions.addValidationError("snapshot is missing", validationException);
        }
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("indices is null", validationException);
        } else {
            for (String index : this.indices) {
                if (index != null) continue;
                validationException = ValidateActions.addValidationError("index is null", validationException);
                break;
            }
        }
        if (this.indicesOptions == null) {
            validationException = ValidateActions.addValidationError("indicesOptions is null", validationException);
        }
        if (this.settings == null) {
            validationException = ValidateActions.addValidationError("settings is null", validationException);
        }
        if ((metadataSize = CreateSnapshotRequest.metadataSize(this.userMetadata)) > MAXIMUM_METADATA_BYTES) {
            validationException = ValidateActions.addValidationError("metadata must be smaller than 1024 bytes, but was [" + metadataSize + "]", validationException);
        }
        return validationException;
    }

    public static int metadataSize(Map<String, Object> userMetadata) {
        int n;
        block9: {
            if (userMetadata == null) {
                return 0;
            }
            XContentBuilder builder = XContentFactory.jsonBuilder();
            try {
                int size;
                builder.value(userMetadata);
                n = size = BytesReference.bytes((XContentBuilder)builder).length();
                if (builder == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OpenSearchException((Throwable)e);
                }
            }
            builder.close();
        }
        return n;
    }

    public CreateSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public CreateSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    @Override
    public CreateSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public CreateSnapshotRequest indices(List<String> indices) {
        this.indices = indices.toArray(new String[0]);
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public CreateSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public boolean partial() {
        return this.partial;
    }

    public CreateSnapshotRequest partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public CreateSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public CreateSnapshotRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateSnapshotRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateSnapshotRequest settings(String source, MediaType mediaType) {
        this.settings = Settings.builder().loadFromSource(source, mediaType).build();
        return this;
    }

    public CreateSnapshotRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)MediaTypeRegistry.JSON);
            builder.map(source);
            this.settings(builder.toString(), builder.contentType());
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public CreateSnapshotRequest includeGlobalState(boolean includeGlobalState) {
        this.includeGlobalState = includeGlobalState;
        return this;
    }

    public boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public Map<String, Object> userMetadata() {
        return this.userMetadata;
    }

    public CreateSnapshotRequest userMetadata(Map<String, Object> userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public CreateSnapshotRequest source(Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("indices")) {
                if (entry.getValue() instanceof String) {
                    this.indices(Strings.splitStringByCommaToArray((String)((String)entry.getValue())));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    this.indices((List)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed indices section, should be an array of strings");
            }
            if (name.equals("partial")) {
                this.partial(XContentMapValues.nodeBooleanValue(entry.getValue(), "partial"));
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("malformed settings section, should indices an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("include_global_state")) {
                this.includeGlobalState = XContentMapValues.nodeBooleanValue(entry.getValue(), "include_global_state");
                continue;
            }
            if (!name.equals("metadata")) continue;
            if (entry.getValue() != null && !(entry.getValue() instanceof Map)) {
                throw new IllegalArgumentException("malformed metadata, should be an object");
            }
            this.userMetadata((Map)entry.getValue());
        }
        this.indicesOptions(IndicesOptions.fromMap(source, this.indicesOptions));
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("repository", this.repository);
        builder.field("snapshot", this.snapshot);
        builder.startArray("indices");
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.field("partial", this.partial);
        if (this.settings != null) {
            builder.startObject("settings");
            if (!this.settings.isEmpty()) {
                this.settings.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.field("include_global_state", this.includeGlobalState);
        if (this.indicesOptions != null) {
            this.indicesOptions.toXContent(builder, params);
        }
        builder.field("metadata", this.userMetadata);
        builder.endObject();
        return builder;
    }

    @Override
    public String getDescription() {
        return "snapshot [" + this.repository + ":" + this.snapshot + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSnapshotRequest that = (CreateSnapshotRequest)o;
        return this.partial == that.partial && this.includeGlobalState == that.includeGlobalState && this.waitForCompletion == that.waitForCompletion && Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.repository, that.repository) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.settings, that.settings) && Objects.equals(this.clusterManagerNodeTimeout, that.clusterManagerNodeTimeout) && Objects.equals(this.userMetadata, that.userMetadata);
    }

    public int hashCode() {
        int result = Objects.hash(this.snapshot, this.repository, this.indicesOptions, this.partial, this.settings, this.includeGlobalState, this.waitForCompletion, this.userMetadata);
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }

    public String toString() {
        return "CreateSnapshotRequest{snapshot='" + this.snapshot + "', repository='" + this.repository + "', indices=" + String.valueOf(this.indices == null ? null : Arrays.asList(this.indices)) + ", indicesOptions=" + String.valueOf(this.indicesOptions) + ", partial=" + this.partial + ", settings=" + String.valueOf(this.settings) + ", includeGlobalState=" + this.includeGlobalState + ", waitForCompletion=" + this.waitForCompletion + ", clusterManagerNodeTimeout=" + String.valueOf(this.clusterManagerNodeTimeout) + ", metadata=" + String.valueOf(this.userMetadata) + "}";
    }
}

