/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.xcontent;

import java.util.function.BiConsumer;
import org.opensearch.common.CheckedFunction;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.AbstractObjectParser;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public final class ObjectParserHelper<Value, Context> {
    public void declareRawObject(AbstractObjectParser<Value, Context> parser, BiConsumer<Value, BytesReference> consumer, ParseField field) {
        CheckedFunction bytesParser = p -> {
            try (XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();){
                builder.copyCurrentStructure((XContentParser)p);
                BytesReference bytesReference = BytesReference.bytes(builder);
                return bytesReference;
            }
        };
        parser.declareField(consumer, bytesParser, field, ObjectParser.ValueType.OBJECT);
    }
}

