/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.Strings;
import org.opensearch.index.VersionType;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;
import org.opensearch.script.ScriptService;
import org.opensearch.script.TemplateScript;

public final class RemoveProcessor
extends AbstractProcessor {
    public static final String TYPE = "remove";
    private final List<TemplateScript.Factory> fields;
    private final List<TemplateScript.Factory> excludeFields;
    private final boolean ignoreMissing;

    RemoveProcessor(String tag, String description, @Nullable List<TemplateScript.Factory> fields, @Nullable List<TemplateScript.Factory> excludeFields, boolean ignoreMissing) {
        super(tag, description);
        if (fields == null && excludeFields == null || fields != null && excludeFields != null) {
            throw new IllegalArgumentException("either fields or excludeFields must be set");
        }
        if (fields != null) {
            this.fields = new ArrayList<TemplateScript.Factory>(fields);
            this.excludeFields = null;
        } else {
            this.fields = null;
            this.excludeFields = new ArrayList<TemplateScript.Factory>(excludeFields);
        }
        this.ignoreMissing = ignoreMissing;
    }

    public List<TemplateScript.Factory> getFields() {
        return this.fields;
    }

    public List<TemplateScript.Factory> getExcludeFields() {
        return this.excludeFields;
    }

    public IngestDocument execute(IngestDocument document) {
        if (this.fields != null && !this.fields.isEmpty()) {
            this.fields.forEach(field -> {
                String versionType;
                String path = document.renderTemplate(field);
                boolean fieldPathIsNullOrEmpty = Strings.isNullOrEmpty((String)path);
                if (fieldPathIsNullOrEmpty || !document.hasField(path)) {
                    if (this.ignoreMissing) {
                        return;
                    }
                    if (fieldPathIsNullOrEmpty) {
                        throw new IllegalArgumentException("field path cannot be null nor empty");
                    }
                    throw new IllegalArgumentException("field [" + path + "] doesn't exist");
                }
                if (path.equals(IngestDocument.Metadata.INDEX.getFieldName()) || path.equals(IngestDocument.Metadata.VERSION.getFieldName()) || path.equals(IngestDocument.Metadata.VERSION_TYPE.getFieldName())) {
                    throw new IllegalArgumentException("cannot remove metadata field [" + path + "]");
                }
                if (path.equals(IngestDocument.Metadata.ID.getFieldName()) && document.hasField(IngestDocument.Metadata.VERSION_TYPE.getFieldName()) && !Objects.equals(versionType = (String)document.getFieldValue(IngestDocument.Metadata.VERSION_TYPE.getFieldName(), String.class), VersionType.toString((VersionType)VersionType.INTERNAL))) {
                    Long version = (Long)document.getFieldValue(IngestDocument.Metadata.VERSION.getFieldName(), Long.class, true);
                    throw new IllegalArgumentException("cannot remove metadata field [_id] when specifying external version for the document, version: " + version + ", version_type: " + versionType);
                }
                document.removeField(path);
            });
        }
        if (this.excludeFields != null && !this.excludeFields.isEmpty()) {
            HashSet excludeFieldSet = new HashSet();
            this.excludeFields.forEach(field -> {
                String path = document.renderTemplate(field);
                if (!Strings.isNullOrEmpty((String)path)) {
                    excludeFieldSet.add(path);
                }
            });
            if (!excludeFieldSet.isEmpty()) {
                HashSet existingFields = new HashSet(document.getSourceAndMetadata().keySet());
                Set metadataFields = document.getMetadata().keySet().stream().map(IngestDocument.Metadata::getFieldName).collect(Collectors.toSet());
                existingFields.forEach(field -> {
                    if (!metadataFields.contains(field) && !excludeFieldSet.contains(field)) {
                        document.removeField(field);
                    }
                });
            }
        }
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public RemoveProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> excludeFields = new ArrayList<String>();
            Object field = ConfigurationUtils.readOptionalObject(config, (String)"field");
            Object excludeField = ConfigurationUtils.readOptionalObject(config, (String)"exclude_field");
            if (field == null && excludeField == null || field != null && excludeField != null) {
                throw ConfigurationUtils.newConfigurationException((String)RemoveProcessor.TYPE, (String)processorTag, (String)"field", (String)"either field or exclude_field must be set");
            }
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RemoveProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            if (field != null) {
                if (field instanceof List) {
                    List stringList = (List)field;
                    fields.addAll(stringList);
                } else {
                    fields.add((String)field);
                }
                List<TemplateScript.Factory> fieldCompiledTemplates = fields.stream().map(f -> ConfigurationUtils.compileTemplate((String)RemoveProcessor.TYPE, (String)processorTag, (String)"field", (String)f, (ScriptService)this.scriptService)).collect(Collectors.toList());
                return new RemoveProcessor(processorTag, description, fieldCompiledTemplates, null, ignoreMissing);
            }
            if (excludeField instanceof List) {
                List stringList = (List)excludeField;
                excludeFields.addAll(stringList);
            } else {
                excludeFields.add((String)excludeField);
            }
            List<TemplateScript.Factory> excludeFieldCompiledTemplates = excludeFields.stream().map(f -> ConfigurationUtils.compileTemplate((String)RemoveProcessor.TYPE, (String)processorTag, (String)"exclude_field", (String)f, (ScriptService)this.scriptService)).collect(Collectors.toList());
            return new RemoveProcessor(processorTag, description, null, excludeFieldCompiledTemplates, ignoreMissing);
        }
    }
}

