/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.node;

import java.util.Objects;
import org.opensearch.painless.Location;
import org.opensearch.painless.node.AExpression;
import org.opensearch.painless.node.AStatement;
import org.opensearch.painless.node.SBlock;
import org.opensearch.painless.phase.UserTreeVisitor;

public class SIfElse
extends AStatement {
    private final AExpression conditionNode;
    private final SBlock ifBlockNode;
    private final SBlock elseBlockNode;

    public SIfElse(int identifier, Location location, AExpression conditionNode, SBlock ifBlockNode, SBlock elseBlockNode) {
        super(identifier, location);
        this.conditionNode = Objects.requireNonNull(conditionNode);
        this.ifBlockNode = ifBlockNode;
        this.elseBlockNode = elseBlockNode;
    }

    public AExpression getConditionNode() {
        return this.conditionNode;
    }

    public SBlock getIfBlockNode() {
        return this.ifBlockNode;
    }

    public SBlock getElseBlockNode() {
        return this.elseBlockNode;
    }

    @Override
    public <Scope> void visit(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        userTreeVisitor.visitIfElse(this, scope);
    }

    @Override
    public <Scope> void visitChildren(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        this.conditionNode.visit(userTreeVisitor, scope);
        if (this.ifBlockNode != null) {
            this.ifBlockNode.visit(userTreeVisitor, scope);
        }
        if (this.elseBlockNode != null) {
            this.elseBlockNode.visit(userTreeVisitor, scope);
        }
    }
}

