/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.io.LegacyShapeWriter;
import org.locationtech.spatial4j.io.ShapeWriter;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.impl.BufferedLine;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;

public class PolyshapeWriter
implements ShapeWriter {
    public static final char KEY_POINT = '0';
    public static final char KEY_LINE = '1';
    public static final char KEY_POLYGON = '2';
    public static final char KEY_MULTIPOINT = '3';
    public static final char KEY_CIRCLE = '4';
    public static final char KEY_BOX = '5';
    public static final char KEY_ARG_START = '(';
    public static final char KEY_ARG_END = ')';
    public static final char KEY_SEPERATOR = ' ';

    public PolyshapeWriter(SpatialContext ctx, SpatialContextFactory factory) {
    }

    @Override
    public String getFormatName() {
        return "POLY";
    }

    @Override
    public void write(Writer output, Shape shape) throws IOException {
        if (shape == null) {
            throw new NullPointerException("Shape can not be null");
        }
        this.write(new Encoder(output), shape);
    }

    public void write(Encoder enc, Shape shape) throws IOException {
        if (shape instanceof Point) {
            Point v = (Point)shape;
            enc.write('0');
            enc.write(v.getX(), v.getY());
            return;
        }
        if (shape instanceof Rectangle) {
            Rectangle v = (Rectangle)shape;
            enc.write('5');
            enc.write(v.getMinX(), v.getMinY());
            enc.write(v.getMaxX(), v.getMaxY());
            return;
        }
        if (shape instanceof BufferedLine) {
            BufferedLine v = (BufferedLine)shape;
            enc.write('1');
            if (v.getBuf() > 0.0) {
                enc.writeArg(v.getBuf());
            }
            enc.write(v.getA().getX(), v.getA().getY());
            enc.write(v.getB().getX(), v.getB().getY());
            return;
        }
        if (shape instanceof BufferedLineString) {
            BufferedLineString v = (BufferedLineString)shape;
            enc.write('1');
            if (v.getBuf() > 0.0) {
                enc.writeArg(v.getBuf());
            }
            BufferedLine last = null;
            for (BufferedLine seg : v.getSegments()) {
                enc.write(seg.getA().getX(), seg.getA().getY());
                last = seg;
            }
            if (last != null) {
                enc.write(last.getB().getX(), last.getB().getY());
            }
            return;
        }
        if (shape instanceof Circle) {
            Circle v = (Circle)shape;
            Point center = v.getCenter();
            double radius = v.getRadius();
            enc.write('4');
            enc.writeArg(radius);
            enc.write(center.getX(), center.getY());
            return;
        }
        if (shape instanceof ShapeCollection) {
            ShapeCollection v = (ShapeCollection)shape;
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                this.write(enc, (Shape)iter.next());
                if (!iter.hasNext()) continue;
                enc.seperator();
            }
            return;
        }
        enc.writer.write("{unkwnwon " + LegacyShapeWriter.writeShape(shape) + "}");
    }

    @Override
    public String toString(Shape shape) {
        try {
            StringWriter buffer = new StringWriter();
            this.write(buffer, shape);
            return buffer.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class Encoder {
        long lastLat = 0L;
        long lastLng = 0L;
        final Writer writer;

        public Encoder(Writer writer) {
            this.writer = writer;
        }

        public void seperator() throws IOException {
            this.writer.write(32);
            this.lastLng = 0L;
            this.lastLat = 0L;
        }

        public void startRing() throws IOException {
            this.writer.write(40);
            this.lastLng = 0L;
            this.lastLat = 0L;
        }

        public void write(char event) throws IOException {
            this.writer.write(event);
            this.lastLng = 0L;
            this.lastLat = 0L;
        }

        public void writeArg(double value) throws IOException {
            this.writer.write(40);
            this.encode(Math.round(value * 100000.0));
            this.writer.write(41);
        }

        public void write(double latitude, double longitude) throws IOException {
            long lat = Math.round(latitude * 100000.0);
            long lng = Math.round(longitude * 100000.0);
            long dLat = lat - this.lastLat;
            long dLng = lng - this.lastLng;
            this.encode(dLat);
            this.encode(dLng);
            this.lastLat = lat;
            this.lastLng = lng;
        }

        private void encode(long v) throws IOException {
            long l = v = v < 0L ? v << 1 ^ 0xFFFFFFFFFFFFFFFFL : v << 1;
            while (v >= 32L) {
                this.writer.write(Character.toChars((int)((0x20L | v & 0x1FL) + 63L)));
                v >>= 5;
            }
            this.writer.write(Character.toChars((int)(v + 63L)));
        }
    }
}

