/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.sql.DataSource;
import oracle.jdbc.datasource.impl.OracleDataSource;
import oracle.rsi.RSIException;
import oracle.rsi.ShardRecord;
import oracle.rsi.internal.AbstractIngester;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.internal.StagingArea;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.routing.ShardInfo;
import oracle.ucp.routing.oracle.OracleShardRoutingCache;

class IngesterForShardedDatabase
extends AbstractIngester {
    private static final String CLASS_NAME = IngesterForShardedDatabase.class.getName();
    private OracleShardRoutingCache routingCache = null;
    private final PoolDataSourceImpl catalogDbPoolDataSource = new PoolDataSourceImpl();
    private final Map<String, DataSourceStagingAreaDuo> mapOfShardNameAndDataSourceStagingAreaDuo = new HashMap<String, DataSourceStagingAreaDuo>();

    protected IngesterForShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        super(rSIBuilder);
        this.startConnectionPool();
        this.initializeStagingArea();
        this.scheduleBufferIntervalTask();
    }

    @Override
    protected void startConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.initializeCatalogDbConnectionPool();
        this.initializeShardRoutingCache();
        this.initializeShardSpecificConnectionPools();
    }

    private void initializeCatalogDbConnectionPool() throws SQLException, UniversalConnectionPoolException {
        this.catalogDbPoolDataSource.setUser(this.dbUser);
        this.catalogDbPoolDataSource.setPassword(this.dbPassword.get());
        this.catalogDbPoolDataSource.setURL(this.dbUrl);
        this.catalogDbPoolDataSource.setInitialPoolSize(1);
        this.catalogDbPoolDataSource.setMinPoolSize(1);
        this.catalogDbPoolDataSource.setConnectionProperty("oracle.jdbc.TcpNoDelay", "true");
        this.catalogDbPoolDataSource.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
        UniversalConnectionPoolManager universalConnectionPoolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        universalConnectionPoolManager.createConnectionPool((UniversalConnectionPoolAdapter)this.catalogDbPoolDataSource);
        universalConnectionPoolManager.startConnectionPool(this.catalogDbPoolDataSource.getConnectionPoolName());
    }

    private void initializeShardRoutingCache() throws UniversalConnectionPoolException {
        Properties properties = new Properties();
        properties.setProperty("user", this.dbUser);
        properties.setProperty("password", this.dbPassword.get());
        properties.setProperty("url", this.dbUrl);
        properties.setProperty("serviceName", this.shardedDbGlobalServiceName);
        this.routingCache = new OracleShardRoutingCache(properties);
    }

    private void initializeShardSpecificConnectionPools() throws SQLException, UniversalConnectionPoolException {
        try (Connection connection = this.catalogDbPoolDataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT db_unique_name, connect_string FROM sha_databases WHERE is_primary='Y'");){
            while (resultSet.next()) {
                OracleDataSource oracleDataSource;
                OracleDataSource oracleDataSource2;
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                if (this.isUseDataLoadMode) {
                    oracleDataSource2 = new OracleDataSource();
                    oracleDataSource2.setURL("jdbc:oracle:thin:@" + string2);
                    oracleDataSource2.setUser(this.dbUser);
                    oracleDataSource2.setPassword(this.dbPassword.get());
                    oracleDataSource2.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
                    oracleDataSource = oracleDataSource2;
                } else {
                    oracleDataSource2 = new PoolDataSourceImpl();
                    oracleDataSource2.setURL("jdbc:oracle:thin:@" + string2);
                    oracleDataSource2.setUser(this.dbUser);
                    oracleDataSource2.setPassword(this.dbPassword.get());
                    oracleDataSource2.setInitialPoolSize(CONNECTION_POOL_SIZE);
                    oracleDataSource2.setMinPoolSize(CONNECTION_POOL_SIZE);
                    oracleDataSource2.setShardingMode(false);
                    oracleDataSource2.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
                    oracleDataSource2.setConnectionProperty("oracle.jdbc.continueBatchOnError", "true");
                    if (this.isUpsert || !this.isUseDP) {
                        oracleDataSource2.setMaxStatements(2);
                    }
                    UniversalConnectionPoolManager universalConnectionPoolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                    universalConnectionPoolManager.createConnectionPool((UniversalConnectionPoolAdapter)oracleDataSource2);
                    universalConnectionPoolManager.startConnectionPool(oracleDataSource2.getConnectionPoolName());
                    oracleDataSource = oracleDataSource2;
                }
                this.mapOfShardNameAndDataSourceStagingAreaDuo.put(string, new DataSourceStagingAreaDuo((DataSource)oracleDataSource));
            }
        }
    }

    @Override
    protected void destroyConnectionPool() throws UniversalConnectionPoolException {
        UniversalConnectionPoolManager universalConnectionPoolManager = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        universalConnectionPoolManager.destroyConnectionPool(this.catalogDbPoolDataSource.getConnectionPoolName());
        for (Map.Entry<String, DataSourceStagingAreaDuo> entry : this.mapOfShardNameAndDataSourceStagingAreaDuo.entrySet()) {
            universalConnectionPoolManager.destroyConnectionPool(((PoolDataSourceImpl)entry.getValue().dataSource()).getConnectionPoolName());
        }
    }

    private void initializeStagingArea() {
        for (String string : this.mapOfShardNameAndDataSourceStagingAreaDuo.keySet()) {
            Consumer<List<Object>> consumer = list -> {
                try {
                    this.jobsQueuedForExecution.incrementAndGet();
                    DataSource dataSource = this.mapOfShardNameAndDataSourceStagingAreaDuo.get(string).dataSource();
                    this.executor.execute(new AbstractIngester.IngestJob(dataSource, (List<Object>)list));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    this.handleRejectedExecutionException(list.size(), rejectedExecutionException.getMessage());
                }
            };
            this.mapOfShardNameAndDataSourceStagingAreaDuo.get(string).set(new StagingArea(this.maxRowsPerStagingQueue, this.bufferInterval, consumer));
        }
    }

    @Override
    protected void flushItemsIfDue(boolean bl) {
        this.mapOfShardNameAndDataSourceStagingAreaDuo.forEach((string, dataSourceStagingAreaDuo) -> dataSourceStagingAreaDuo.stagingArea().flushIfDue(bl));
    }

    @Override
    protected void validate(Object object) {
        if (!(object instanceof ShardRecord)) {
            throw new RSIException("Unknown item type. Discarding.");
        }
        super.validate(((ShardRecord)object).values());
    }

    @Override
    protected void accept(Object object) {
        ShardRecord shardRecord = (ShardRecord)object;
        Set set = this.routingCache.getChunkInfoForKey(shardRecord.shardingKey(), shardRecord.shardingGroupKey()).getShardInfo();
        Optional<ShardInfo> optional = set.stream().filter(shardInfo -> this.mapOfShardNameAndDataSourceStagingAreaDuo.containsKey(shardInfo.getName())).findFirst();
        if (!optional.isPresent()) {
            this.debug(Level.WARNING, CLASS_NAME, "accept", "Skipping the record as the sharding key does not map to any partition", null, new Object[0]);
            return;
        }
        String string = optional.get().getName();
        this.mapOfShardNameAndDataSourceStagingAreaDuo.get(string).stagingArea().accept(shardRecord.values());
    }

    @Override
    protected void cleanup() {
        this.mapOfShardNameAndDataSourceStagingAreaDuo.forEach((string, dataSourceStagingAreaDuo) -> dataSourceStagingAreaDuo.stagingArea().close());
    }

    private class DataSourceStagingAreaDuo {
        private DataSource dataSource;
        private StagingArea stagingArea;

        public DataSourceStagingAreaDuo(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void set(StagingArea stagingArea) {
            this.stagingArea = stagingArea;
        }

        public StagingArea stagingArea() {
            return this.stagingArea;
        }

        public DataSource dataSource() {
            return this.dataSource;
        }
    }
}

