/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.RLBInfo;
import oracle.ucp.util.RingBuffer;

public class MetricsAccumulator
implements RLBInfo {
    static final String CLASS_NAME = MetricsAccumulator.class.getName();
    final Frame cumulative = new Frame();
    private final ReentrantLock metricsAccumulatorLock = new ReentrantLock();
    private RingBuffer<RLBInfo.Frame> history = new RingBuffer();
    private Collection<OracleDatabaseInstanceInfo> racMetadata = null;

    public Frame getCumulative() {
        return this.cumulative;
    }

    @Override
    public Frame getCurrentFrame() {
        List<RLBInfo.Frame> list = this.history.getAsList();
        return list.size() > 0 ? (Frame)list.get(0) : new Frame();
    }

    @Override
    public Frame getPreviousFrame() {
        List<RLBInfo.Frame> list = this.history.getAsList();
        return list.size() > 2 ? (Frame)list.get(1) : new Frame();
    }

    @Override
    public List<RLBInfo.Frame> getReel() {
        return this.history.getAsList();
    }

    @Override
    public Collection<OracleDatabaseInstanceInfo> getInstances() {
        return this.racMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newEvent(String serviceName, byte[] eventBody, Collection<OracleDatabaseInstanceInfo> racMetadata) {
        this.metricsAccumulatorLock.lock();
        try {
            this.racMetadata = racMetadata;
            for (OracleDatabaseInstanceInfo info : racMetadata) {
                if (null == info) continue;
                InstanceStats stats = this.cumulative.getStats(info.getInstanceName());
                stats.total = info.getNumberOfConnectionsCount();
                stats.percent = info.getAdvisoryPercent();
                Frame currentFrame = this.getCurrentFrame();
                if (null == currentFrame) continue;
                stats = (InstanceStats)currentFrame.getStats(info.getInstanceName());
                stats.total = info.getNumberOfConnectionsCount();
                stats.percent = info.getAdvisoryPercent();
            }
            this.history.addItem(new Frame(serviceName, eventBody));
        }
        finally {
            this.metricsAccumulatorLock.unlock();
        }
    }

    private void resetCumulative() {
        assert (false) : "all cumulative RLB counters are reset because long int capacity exhausted";
        this.getCumulative().reset();
    }

    private void resetCurrent() {
        assert (false) : "all current frame RLB counters are reset because long int capacity exhausted";
        this.getCurrentFrame().reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementOpened(OracleUniversalPooledConnection conn) {
        this.metricsAccumulatorLock.lock();
        try {
            Frame currentFrame;
            String instance = conn.getInstance();
            if (++this.cumulative.getStats(instance).created < 0L) {
                this.resetCumulative();
            }
            if (null != (currentFrame = this.getCurrentFrame()) && ++currentFrame.getStats(instance).created < 0L) {
                this.resetCurrent();
            }
        }
        finally {
            this.metricsAccumulatorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementClosed(OracleUniversalPooledConnection conn) {
        this.metricsAccumulatorLock.lock();
        try {
            Frame currentFrame;
            String instance = conn.getInstance();
            if (++this.cumulative.getStats(instance).closed < 0L) {
                this.resetCumulative();
            }
            if (null != (currentFrame = this.getCurrentFrame()) && ++currentFrame.getStats(instance).closed < 0L) {
                this.resetCurrent();
            }
        }
        finally {
            this.metricsAccumulatorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementAborted(OracleUniversalPooledConnection conn) {
        this.metricsAccumulatorLock.lock();
        try {
            Frame currentFrame;
            String instance = conn.getInstance();
            if (++this.cumulative.getStats(instance).aborted < 0L) {
                this.resetCumulative();
            }
            if (null != (currentFrame = this.getCurrentFrame()) && ++currentFrame.getStats(instance).aborted < 0L) {
                this.resetCurrent();
            }
        }
        finally {
            this.metricsAccumulatorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementBorrowed(OracleUniversalPooledConnection conn) {
        this.metricsAccumulatorLock.lock();
        try {
            String instance = conn.getInstance();
            InstanceStats stats = this.cumulative.getStats(instance);
            if (++stats.borrowed < 0L) {
                this.resetCumulative();
            }
            stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
            Frame currentFrame = this.getCurrentFrame();
            if (null != currentFrame) {
                stats = currentFrame.getStats(instance);
                if (++stats.borrowed < 0L) {
                    this.resetCurrent();
                }
                if (++currentFrame.totalBorrowed < 0L) {
                    this.resetCurrent();
                }
                stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
                if (null != conn.getRlbBorrowStats()) {
                    throw new IllegalStateException("internal error: RLBStatisticsFrame already set");
                }
                conn.setRlbBorrowStats(currentFrame);
            }
        }
        finally {
            this.metricsAccumulatorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReturned(OracleUniversalPooledConnection conn) {
        this.metricsAccumulatorLock.lock();
        try {
            String instance = conn.getInstance();
            InstanceStats stats = this.cumulative.getStats(instance);
            if (++stats.returned < 0L) {
                this.resetCumulative();
            }
            stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
            long bs = System.currentTimeMillis() - conn.getBorrowedStartTime();
            InstanceStats instanceStats = stats;
            instanceStats.timeBorrowedTotal = instanceStats.timeBorrowedTotal + bs;
            stats.timeBorrowedMin = Math.min(bs, stats.timeBorrowedMin);
            stats.timeBorrowedMax = Math.max(bs, stats.timeBorrowedMax);
            Frame frame = (Frame)conn.getRlbBorrowStats();
            if (null == frame) {
                return;
            }
            conn.setRlbBorrowStats(null);
            stats = frame.getStats(instance);
            if (++stats.returned < 0L) {
                this.resetCurrent();
            }
            stats.peakBorrowed = Math.max(stats.borrowed - stats.returned, stats.peakBorrowed);
            InstanceStats instanceStats2 = stats;
            instanceStats2.timeBorrowedTotal = instanceStats2.timeBorrowedTotal + bs;
            stats.timeBorrowedMin = Math.min(bs, stats.timeBorrowedMin);
            stats.timeBorrowedMax = Math.max(bs, stats.timeBorrowedMax);
        }
        finally {
            this.metricsAccumulatorLock.unlock();
        }
    }

    public String toString() {
        this.metricsAccumulatorLock.lock();
        try {
            String string = "cumulative: " + this.cumulative.toString() + "; delta: " + super.toString();
            return string;
        }
        finally {
            this.metricsAccumulatorLock.unlock();
        }
    }

    public String toString(int nFrames) {
        this.metricsAccumulatorLock.lock();
        try {
            String string = "cumulative: " + this.cumulative.toString() + "; delta: " + this.history.toString(nFrames);
            return string;
        }
        finally {
            this.metricsAccumulatorLock.unlock();
        }
    }

    public static class Frame
    implements RLBInfo.Frame {
        final long timestamp = System.currentTimeMillis();
        final String serviceName;
        final byte[] eventBody;
        public long totalBorrowed = 0L;
        private static final ReentrantLock frameLock = new ReentrantLock();
        public final Map<String, InstanceStats> distribution = new HashMap<String, InstanceStats>();

        Frame() {
            this(null, null);
        }

        Frame(String serviceName, byte[] eventBody) {
            this.serviceName = serviceName;
            this.eventBody = eventBody;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public long getTotalBorrowed() {
            return this.totalBorrowed;
        }

        public void reset() {
            frameLock.lock();
            try {
                for (InstanceStats stats : this.distribution.values()) {
                    stats.reset();
                }
            }
            finally {
                frameLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InstanceStats getStats(String instance) {
            frameLock.lock();
            try {
                InstanceStats stats = this.distribution.get(instance);
                if (null == stats) {
                    stats = new InstanceStats();
                    this.distribution.put(instance, stats);
                }
                InstanceStats instanceStats = stats;
                return instanceStats;
            }
            finally {
                frameLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            frameLock.lock();
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("timestamp=").append(new Date(this.timestamp)).append(", ");
                if (null != this.serviceName) {
                    sb.append("serviceName=").append(this.serviceName).append(", ");
                }
                if (null != this.eventBody) {
                    sb.append("eventBody=").append(new String(this.eventBody)).append(", ");
                }
                for (Map.Entry<String, InstanceStats> entry : this.distribution.entrySet()) {
                    sb.append("(instanceName=").append(entry.getKey()).append(entry.getValue()).append(')');
                }
                String string = sb.toString();
                return string;
            }
            finally {
                frameLock.unlock();
            }
        }
    }

    public static class InstanceStats
    implements RLBInfo.InstanceStats {
        private long created = 0L;
        private long closed = 0L;
        private long aborted = 0L;
        private long borrowed = 0L;
        private long peakBorrowed = 0L;
        private long returned = 0L;
        private int total = 0;
        private long timeBorrowedMin = Long.MAX_VALUE;
        private long timeBorrowedMax = Long.MIN_VALUE;
        private long timeBorrowedTotal = 0L;
        private float percent = 0.0f;
        private static final ReentrantLock instanceStatsLock = new ReentrantLock();

        @Override
        public long getConnsCreated() {
            return this.created;
        }

        @Override
        public long getConnsClosed() {
            return this.closed;
        }

        @Override
        public long getConnsAborted() {
            return this.aborted;
        }

        @Override
        public long getConnsBorrowed() {
            return this.borrowed;
        }

        @Override
        public long getConnsBorrowedPeak() {
            return this.peakBorrowed;
        }

        @Override
        public long getConnsReturned() {
            return this.returned;
        }

        @Override
        public long getTimeBorrowedMin() {
            return this.timeBorrowedMin;
        }

        @Override
        public long getTimeBorrowedMax() {
            return this.timeBorrowedMax;
        }

        @Override
        public long getTimeBorrowedTotal() {
            return this.timeBorrowedTotal;
        }

        public int getConnsTotal() {
            return this.total;
        }

        public float getAdvisoryPercent() {
            return this.percent;
        }

        public void reset() {
            instanceStatsLock.lock();
            try {
                this.returned = 0L;
                this.borrowed = 0L;
                this.aborted = 0L;
                this.closed = 0L;
                this.created = 0L;
                this.total = 0;
                this.percent = 0.0f;
            }
            finally {
                instanceStatsLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            instanceStatsLock.lock();
            try {
                long timeBorrowedAverage = 0L == this.returned ? 0L : this.timeBorrowedTotal / this.returned;
                String string = " created=" + this.created + " closed=" + this.closed + " aborted=" + this.aborted + " borrowed=" + this.borrowed + " peakBorrowed=" + this.peakBorrowed + " timeBorrowedMin=" + this.timeBorrowedMin + " timeBorrowedMax=" + this.timeBorrowedMax + " timeBorrowedAverage=" + timeBorrowedAverage + " returned=" + this.returned + " total=" + this.total + " percent=" + this.percent;
                return string;
            }
            finally {
                instanceStatsLock.unlock();
            }
        }
    }
}

