/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import oracle.ucp.jdbc.DatasourceConfigManager;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.util.UCPErrorHandler;

public class PoolDataSourceFactory {
    public static PoolDataSource getPoolDataSource() {
        return new PoolDataSourceImpl();
    }

    public static PoolDataSource getPoolDataSource(String dataSourceName) throws SQLException {
        return PoolDataSourceFactory.getPoolDataSource(dataSourceName, null);
    }

    public static PoolDataSource getPoolDataSource(String dataSourceName, InputStream is) throws SQLException {
        DatasourceConfigManager dataSourceConfigMgr = DatasourceConfigManager.getDatasourceConfigManager(is);
        if (dataSourceConfigMgr == null) {
            UCPErrorHandler.throwSQLException(75, null);
        }
        return dataSourceConfigMgr.getPoolDataSource(dataSourceName);
    }

    public static PoolDataSource getPoolDataSource(Properties configuration) throws SQLException {
        PoolDataSourceFactory.validateConfig(configuration, false);
        String dataSourceName = configuration.getProperty("dataSourceName");
        Map<String, PoolDataSource> poolDatasources = DatasourceConfigManager.getPoolDataSources();
        PoolDataSourceImpl poolDatasource = new PoolDataSourceImpl();
        poolDatasource.setConfigureNewDataSource(true);
        poolDatasource.setDataSourceName(dataSourceName);
        poolDatasource.reconfigureDataSource(configuration);
        poolDatasources.put(dataSourceName, poolDatasource);
        return poolDatasource;
    }

    public static PoolXADataSource getPoolXADataSource() {
        return new PoolXADataSourceImpl();
    }

    public static PoolXADataSource getPoolXADataSource(String dataSourceName) throws SQLException {
        DatasourceConfigManager dataSourceConfigMgr = DatasourceConfigManager.getDatasourceConfigManager();
        if (dataSourceConfigMgr == null) {
            UCPErrorHandler.throwSQLException(75, null);
        }
        return dataSourceConfigMgr.getPoolXADataSource(dataSourceName);
    }

    public static PoolXADataSource getPoolXADataSource(Properties configuration) throws SQLException {
        PoolDataSourceFactory.validateConfig(configuration, true);
        String dataSourceName = configuration.getProperty("dataSourceName");
        Map<String, PoolXADataSource> poolXADatasources = DatasourceConfigManager.getPoolXADataSources();
        PoolXADataSourceImpl poolXADatasource = new PoolXADataSourceImpl();
        ((PoolDataSourceImpl)poolXADatasource).setConfigureNewDataSource(true);
        poolXADatasource.setDataSourceName(dataSourceName);
        ((PoolDataSourceImpl)poolXADatasource).reconfigureDataSource(configuration);
        poolXADatasources.put(dataSourceName, poolXADatasource);
        return poolXADatasource;
    }

    private static void validateConfig(Properties configuration, boolean isXADataSource) throws SQLException {
        if (configuration == null) {
            throw new IllegalArgumentException("Invalid datasource input configuration");
        }
        String configPoolName = configuration.getProperty("connectionPoolName");
        if (configPoolName == null) {
            throw new IllegalArgumentException("Invalid input, connection pool name does not exist in input configuration");
        }
        String dataSourceName = configuration.getProperty("dataSourceName");
        if (dataSourceName == null) {
            throw new IllegalArgumentException("Invalid input, data source name does not exist in input configuration");
        }
        Map<String, Object> poolConfigMap = DatasourceConfigManager.getPoolConfigFromXML(configPoolName);
        if (poolConfigMap == null) {
            UCPErrorHandler.throwSQLException(74, null);
        }
        if (!isXADataSource && Boolean.parseBoolean((String)poolConfigMap.get("is-xa-pool"))) {
            UCPErrorHandler.throwSQLException(79, null);
        } else if (isXADataSource && !Boolean.parseBoolean((String)poolConfigMap.get("is-xa-pool"))) {
            UCPErrorHandler.throwSQLException(80, null);
        }
        Map<String, PoolDataSource> poolDatasources = DatasourceConfigManager.getPoolDataSources();
        Map<String, PoolXADataSource> poolXADatasources = DatasourceConfigManager.getPoolXADataSources();
        if (poolDatasources.containsKey(dataSourceName) || poolXADatasources.containsKey(dataSourceName)) {
            UCPErrorHandler.throwSQLException(78, null);
        }
    }
}

