/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import oracle.jdbc.driver.DatabaseError;

class TcpFastOpen {
    private static final String TFO_JDBC_LIB_NAME = "tfojdbc1";
    private static final String LIB_TFO_JDBC = "libtfojdbc1.so";
    private static RuntimeException libTfoJdbcPreloadException = null;
    private static boolean IS_PREFER_IPV4_STACK_PROPERTY_SET = false;
    private static final TcpFastOpen INSTANCE = new TcpFastOpen();

    private TcpFastOpen() {
    }

    public static TcpFastOpen getInstance() {
        return INSTANCE;
    }

    private static boolean isLibTfoJdbcPreloadSet() {
        String ldPreloadValue = TcpFastOpen.getPreloadEnvValue();
        if (ldPreloadValue != null && ldPreloadValue.contains(LIB_TFO_JDBC)) {
            return true;
        }
        libTfoJdbcPreloadException = new RuntimeException(DatabaseError.createSqlException(1739).getMessage());
        return false;
    }

    private static void loadLibTfoJdbcLibrary() {
        try {
            AccessController.doPrivileged(() -> {
                System.loadLibrary(TFO_JDBC_LIB_NAME);
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void init() {
        if (TcpFastOpen.isLibTfoJdbcPreloadSet()) {
            TcpFastOpen.loadLibTfoJdbcLibrary();
        }
        try {
            AccessController.doPrivileged(() -> {
                IS_PREFER_IPV4_STACK_PROPERTY_SET = "true".equals(System.getProperty("java.net.preferIPv4Stack"));
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getPreloadEnvValue() {
        String[] value = new String[]{null};
        try {
            AccessController.doPrivileged(() -> {
                value[0] = System.getenv("LD_PRELOAD");
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException(ex);
        }
        return value[0];
    }

    public static InetSocketAddress setTcpFastOpenBytes(InetSocketAddress socketAddress, byte[] tcpFastOpenBytes) {
        if (libTfoJdbcPreloadException != null) {
            throw libTfoJdbcPreloadException;
        }
        if (socketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        InetAddress inetAddr = socketAddress.getAddress();
        byte[] addr = inetAddr.getAddress();
        return TcpFastOpen.setTcpFastOpenBytes0(addr, addr.length, socketAddress.getPort(), tcpFastOpenBytes, IS_PREFER_IPV4_STACK_PROPERTY_SET);
    }

    public static String getErrorMessage(InetSocketAddress socketAddress) {
        try {
            InetAddress inetAddr = socketAddress.getAddress();
            byte[] addr = inetAddr.getAddress();
            return TcpFastOpen.getErrorMessage0(addr, addr.length, socketAddress.getPort());
        }
        catch (UnsatisfiedLinkError ex) {
            return null;
        }
    }

    public static int getBytesSentAndRemove(InetSocketAddress socketAddress) {
        InetAddress inetAddr = socketAddress.getAddress();
        byte[] addr = inetAddr.getAddress();
        return TcpFastOpen.getBytesSentAndRemove(addr, addr.length, socketAddress.getPort());
    }

    private static native InetSocketAddress setTcpFastOpenBytes0(byte[] var0, int var1, int var2, byte[] var3, boolean var4);

    private static native String getErrorMessage0(byte[] var0, int var1, int var2);

    private static native int getBytesSentAndRemove(byte[] var0, int var1, int var2);
}

