/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JakartaArrayImpl;
import oracle.jdbc.driver.json.tree.JsonpArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonArrayImpl
implements OracleJsonArray {
    List<OracleJsonValue> list = new ArrayList<OracleJsonValue>();

    public OracleJsonArrayImpl() {
    }

    public OracleJsonArrayImpl(OracleJsonArray other) {
        block4: for (OracleJsonValue value : other) {
            switch (value.getOracleJsonType()) {
                case OBJECT: {
                    this.list.add(new OracleJsonObjectImpl(value.asJsonObject()));
                    continue block4;
                }
                case ARRAY: {
                    this.list.add(new OracleJsonArrayImpl(value.asJsonArray()));
                    continue block4;
                }
            }
            this.list.add(value);
        }
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.ARRAY;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<OracleJsonValue> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public OracleJsonValue get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<OracleJsonValue> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<OracleJsonValue> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public <T extends OracleJsonValue> List<T> getValuesAs(Class<T> c) {
        return this;
    }

    @Override
    public String getString(int index) {
        return this.list.get(index).asJsonString().getString();
    }

    @Override
    public int getInt(int index) {
        return ((OracleJsonNumber)this.list.get(index)).intValue();
    }

    @Override
    public double getDouble(int index) {
        return ((OracleJsonNumber)this.list.get(index)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return ((OracleJsonNumber)this.list.get(index)).bigDecimalValue();
    }

    @Override
    public long getLong(int index) {
        return ((OracleJsonNumber)this.list.get(index)).longValue();
    }

    @Override
    public boolean getBoolean(int index) {
        OracleJsonValue v = this.list.get(index);
        if (v.equals(OracleJsonValue.TRUE)) {
            return true;
        }
        if (v.equals(OracleJsonValue.FALSE)) {
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean isNull(int index) {
        return OracleJsonValue.NULL.equals(this.list.get(index));
    }

    @Override
    public LocalDateTime getLocalDateTime(int index) {
        OracleJsonValue value = this.list.get(index);
        if (value.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return value.asJsonDate().getLocalDateTime();
        }
        return value.asJsonTimestamp().getLocalDateTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(int index) {
        OracleJsonValue value = this.list.get(index);
        return value.asJsonTimestampTZ().getOffsetDateTime();
    }

    @Override
    public byte[] getBytes(int index) {
        return this.list.get(index).asJsonBinary().getBytes();
    }

    @Override
    public OracleJsonValue set(int index, OracleJsonValue element) {
        this.checkNull(element);
        return this.list.set(index, element);
    }

    public OracleJsonArray subList(int fromIndex, int toIndex) {
        OracleJsonArrayImpl arr = new OracleJsonArrayImpl();
        for (int i = fromIndex; i < toIndex; ++i) {
            arr.add(this.get(i));
        }
        return arr;
    }

    @Override
    public void add(double value) {
        this.add(new OracleJsonDoubleImpl(value));
    }

    @Override
    public void add(long value) {
        this.add(new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.LONG));
    }

    @Override
    public void add(BigDecimal value) {
        this.add(new OracleJsonDecimalImpl(value));
    }

    @Override
    public void add(boolean value) {
        this.add(value ? OracleJsonValue.TRUE : OracleJsonValue.FALSE);
    }

    @Override
    public void add(String value) {
        this.add(new OracleJsonStringImpl(value));
    }

    @Override
    public void add(int value) {
        this.add(new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.INT));
    }

    @Override
    public boolean addAll(Collection<? extends OracleJsonValue> c) {
        for (OracleJsonValue oracleJsonValue : c) {
            this.checkNull(oracleJsonValue);
            this.list.add(oracleJsonValue);
        }
        return c.size() > 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends OracleJsonValue> c) {
        for (OracleJsonValue oracleJsonValue : c) {
            this.checkNull(oracleJsonValue);
        }
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public OracleJsonValue set(int index, boolean value) {
        return this.list.set(index, value ? OracleJsonValue.TRUE : OracleJsonValue.FALSE);
    }

    @Override
    public void add(int index, OracleJsonValue element) {
        this.checkNull(element);
        this.list.add(index, element);
    }

    private void checkNull(OracleJsonValue element) {
        if (element == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public OracleJsonValue remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public OracleJsonValue set(int index, String value) {
        return this.list.set(index, new OracleJsonStringImpl(value));
    }

    @Override
    public OracleJsonValue set(int index, int value) {
        return this.list.set(index, new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.INT));
    }

    @Override
    public OracleJsonValue set(int index, double value) {
        return this.list.set(index, new OracleJsonDoubleImpl(value));
    }

    @Override
    public OracleJsonValue set(int index, long value) {
        return this.list.set(index, new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.LONG));
    }

    @Override
    public OracleJsonValue set(int index, BigDecimal value) throws OracleJsonException {
        return this.list.set(index, new OracleJsonDecimalImpl(value));
    }

    @Override
    public OracleJsonValue setNull(int index) {
        return this.list.set(index, OracleJsonValue.NULL);
    }

    @Override
    public void addNull() {
        this.list.add(OracleJsonValue.NULL);
    }

    @Override
    public OracleJsonValue set(int index, LocalDateTime value) {
        return this.list.set(index, new OracleJsonTimestampImpl(value));
    }

    @Override
    public OracleJsonValue set(int index, OffsetDateTime value) {
        return this.list.set(index, new OracleJsonTimestampTZImpl(value));
    }

    @Override
    public void add(LocalDateTime value) {
        this.list.add(new OracleJsonTimestampImpl(value));
    }

    @Override
    public void add(OffsetDateTime value) {
        this.list.add(new OracleJsonTimestampTZImpl(value));
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public OracleJsonValue set(int index, byte[] value) {
        return this.list.set(index, new OracleJsonBinaryImpl(value, false));
    }

    @Override
    public void add(byte[] value) {
        this.list.add(new OracleJsonBinaryImpl(value, false));
    }

    @Override
    public boolean add(OracleJsonValue e) {
        this.checkNull(e);
        return this.list.add(e);
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        JsonSerializerImpl ser = new JsonSerializerImpl(writer);
        ser.write(this);
        ser.close();
        return writer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.list.equals(other);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public <T> T wrap(Class<T> c) {
        if (Jsonp.isJakartaJson(c)) {
            return c.cast(new JakartaArrayImpl(this));
        }
        return c.cast(new JsonpArrayImpl(this));
    }
}

