/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import jakarta.json.JsonValue;
import oracle.jdbc.driver.json.binary.JakartaOsonArray;
import oracle.jdbc.driver.json.binary.JakartaOsonObject;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonValueFactory;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.sql.json.OracleJsonDecimal;

public class JakartaOsonValueFactory
extends OsonValueFactory {
    public static JakartaOsonValueFactory INSTANCE = new JakartaOsonValueFactory();

    private JakartaOsonValueFactory() {
    }

    @Override
    Object createBinary(OsonContext ctx, int pos, int len, boolean isId) {
        byte[] raw = new byte[len];
        ctx.b.position(pos);
        ctx.b.get(raw);
        return new JakartaPrimitive.JakartaBinaryImpl(raw, isId);
    }

    @Override
    public OsonAbstractArray createArray(OsonContext ctx, int pos) {
        return new JakartaOsonArray(ctx, pos);
    }

    @Override
    public OsonAbstractObject createObject(OsonContext ctx, int pos) {
        return new JakartaOsonObject(ctx, pos);
    }

    @Override
    public JakartaPrimitive.JakartaStringImpl createString(OsonContext ctx, int pos, int len) {
        ctx.b.position(pos);
        return new JakartaPrimitive.JakartaStringImpl(ctx.b.readString(len));
    }

    @Override
    public JakartaPrimitive.JakartaNumberImpl createNumber(byte[] raw, OracleJsonDecimal.TargetType type) {
        return new JakartaPrimitive.JakartaNumberImpl(raw, type);
    }

    @Override
    public JakartaPrimitive.JakartaStringNumberImpl createStringNumber(String value) {
        return new JakartaPrimitive.JakartaStringNumberImpl(value);
    }

    @Override
    public JakartaPrimitive.JakartaDoubleImpl createDouble(double value) {
        return new JakartaPrimitive.JakartaDoubleImpl(value);
    }

    @Override
    public JakartaPrimitive.JakartaTimestampImpl createTimestamp(byte[] raw) {
        return new JakartaPrimitive.JakartaTimestampImpl(raw);
    }

    @Override
    public Object createTimestampTZ(byte[] raw) {
        return new JakartaPrimitive.JakartaTimestampTZImpl(raw);
    }

    @Override
    public JakartaPrimitive.JakartaFloatImpl createFloat(float flt) {
        return new JakartaPrimitive.JakartaFloatImpl(flt);
    }

    @Override
    public JakartaPrimitive.JakartaDateImpl createDate(byte[] raw) {
        return new JakartaPrimitive.JakartaDateImpl(raw);
    }

    @Override
    public JakartaPrimitive.JakartaIntervalYMImpl createIntervalYM(byte[] raw) {
        return new JakartaPrimitive.JakartaIntervalYMImpl(raw);
    }

    @Override
    public JakartaPrimitive.JakartaIntervalDSImpl createIntervalDS(byte[] raw) {
        return new JakartaPrimitive.JakartaIntervalDSImpl(raw);
    }

    @Override
    public Object createTrue() {
        return JsonValue.TRUE;
    }

    @Override
    public Object createFalse() {
        return JsonValue.FALSE;
    }

    @Override
    public Object createNull() {
        return JsonValue.NULL;
    }

    @Override
    Object createVector(OsonContext ctx, int pos, int len) {
        ctx.b.position(pos);
        byte[] res = new byte[len];
        ctx.b.get(res);
        return new JakartaPrimitive.JakartaVectorImpl(res);
    }
}

