/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.VarcharBinder;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

class StringBinder
extends VarcharBinder {
    private static final String CLASS_NAME = StringBinder.class.getName();

    StringBinder(String val) {
        super(val);
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        String value = this.paramVal;
        if (clearPriorBindValues) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            bindIndicators[indoffset] = 0;
            int l = value.length();
            if (bindUseDBA) {
                long pos;
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                CharacterSet targetCS = stmt.getCharacterSetForBind(bindPosition, (short)formOfUse);
                int convertedBytesLengthActual = targetCS.getOracleId() == 1 && !stmt.connection.isStrictAsciiConversion ? bindData.putAsciiString(value) : bindData.putStringWithReplacement(value, targetCS);
                bindDataLengths[bindDataIndex] = convertedBytesLengthActual;
                stmt.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "bind", "lastBoundDataLengths={0}. ", (String)null, (Throwable)null, (Object)convertedBytesLengthActual);
                stmt.lastBoundDataLengths[bindPosition] = convertedBytesLengthActual;
                l = convertedBytesLengthActual;
            } else {
                value.getChars(0, l, bindChars, charoffset + 1);
                bindChars[charoffset] = (char)(l <<= 1);
            }
            bindIndicators[lenoffset] = l > 65532 ? -2 : (short)(l + 2);
        }
        return localCheckSum;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        String value = this.paramVal;
        CharacterSet targetCS = stmt.getCharacterSetForBind(bindPosition, (short)formOfUse);
        if (targetCS.getOracleId() == 1 && !stmt.connection.isStrictAsciiConversion) {
            String asciiString = value;
            if (asciiString == null || asciiString.length() == 0) {
                return null;
            }
            int length = asciiString.length();
            byte[] asciiBytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                asciiBytes[i] = (byte)asciiString.charAt(i);
            }
            return SQLUtil.makeDatum((OracleConnection)stmt.connection, asciiBytes, internalType, null, 0);
        }
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, targetCS.convertWithReplacement(value), internalType, null, 0);
    }
}

