/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.launcher;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JTextPane;

public abstract class DroppableTextPane
extends JTextPane
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DragSource dragSource = DragSource.getDefaultDragSource();

    public DroppableTextPane() {
        new DropTarget(this, this);
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent DragSourceDropEvent2) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dragExit(DragSourceEvent DragSourceEvent2) {
    }

    @Override
    public void dragOver(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : fileList) {
                    if (file.isFile()) {
                        this.fileDropped(file);
                    }
                    if (!file.isDirectory()) continue;
                    this.directoryDropped(file);
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException | IOException io) {
            io.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
    }

    public void fileDropped(File file) {
    }

    public void directoryDropped(File file) {
    }
}

