/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ons.CallBack;
import oracle.ons.Closable;
import oracle.ons.Message;
import oracle.ons.Node;
import oracle.ons.Notification;
import oracle.ons.NotificationCallback;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.Publisher;
import oracle.ons.SubscriptionException;
import oracle.ons.SubscriptionRefused;

public class Subscriber
implements Closable {
    public static final int CBMODE_NOCALLBACK = 0;
    public static final int CBMODE_ONETHREAD = 1;
    public static final int CBMODE_THREADPERCB = 2;
    @Deprecated
    public static final int ErrorSubscriberInvalid = 1;
    @Deprecated
    public static final int ErrorNotificationReceive = 2;
    @Deprecated
    public static final int ErrorSubscriberRegister = 3;
    @Deprecated
    public static final int ErrorServerSupport = 4;
    public static final String RegisterType = "ONSregister";
    public static final String UnregisterType = "ONSunregister";
    public static final String SubscriberId = "SubscriberID";
    public static final String Registerd = "ONSregisterID";
    public static final String DisconnectId = "ONSdisconnectID";
    public static final String DirectRoute = "DirectRoute";
    public static final String StatusResult = "Result";
    public static final String ResultSuccess = "success";
    public static final String StatusMessage = "Message";
    private String componentName = null;
    private ONSConfiguration config;
    private static AtomicInteger globalId = new AtomicInteger(1);
    private static final int STATE_NOT_INITIALIZED = 0;
    private static final int STATE_NOT_REGISTERED = 1;
    private static final int STATE_REGISTERED = 2;
    private static final int STATE_CLOSED = 3;
    private AtomicInteger state = new AtomicInteger(0);
    protected int id;
    private String subscription;
    private final BlockingQueue<Notification> notificationQueue = new LinkedBlockingDeque<Notification>();
    protected volatile CallBack callback = null;
    private volatile int callbackMode = 0;
    private volatile ONSException subscriptionError = null;
    private volatile boolean registered = false;
    private final Semaphore subscriptionStatusLock = new Semaphore(0, false);
    private NotificationNetwork network;
    static final Notification loopbackCloseEvent = new Notification(null, "~InternalSubscriberCloseNotification", null);
    private boolean wantSystemNotifications = false;
    private final SingletonCallbackAction callbackSingleton = new SingletonCallbackAction();

    @Override
    public void close() {
        if (this.state.compareAndSet(2, 3)) {
            this.network.logger.fine("ONS Subscriber " + this + "(" + this.id + ") close");
            this.network.unregisterSubscriber(this);
            this.network.release();
            this.registered = false;
            this.notificationQueue.add(loopbackCloseEvent);
        }
    }

    public String getSubscriptionKey() {
        return this.subscription;
    }

    public boolean isOpen() {
        return this.registered;
    }

    protected boolean handleInternalNotification(Notification notification) {
        if (notification.verb.equals("status")) {
            if (notification.getResult() == 1) {
                if (this.state.compareAndSet(1, 2)) {
                    this.registered = true;
                }
            } else {
                this.subscriptionError = new SubscriptionRefused(notification.getMessage("Unknown error"));
                this.network.unregisterSubscriber(this);
            }
            this.subscriptionStatusLock.release();
            return true;
        }
        return false;
    }

    private void deliverNotification(Notification notification) throws InterruptedException {
        if (this.callback != null && this.callbackMode == 2) {
            if (!notification.isSystemNotification() || this.wantSystemNotifications || this.callback instanceof NotificationCallback) {
                this.network.master.getWorkloadManager().schedule(new CallCallbackAction(this.callback, notification));
            }
        } else {
            this.notificationQueue.put(notification);
            if (this.callback != null && this.callbackMode == 1 && !this.callbackSingleton.hasCarrier() && !this.notificationQueue.isEmpty()) {
                this.network.master.getWorkloadManager().schedule(this.callbackSingleton);
            }
        }
    }

    protected void put(Notification notification) throws InterruptedException {
        if (this.handleInternalNotification(notification)) {
            if (this.wantSystemNotifications) {
                this.deliverNotification(new Notification(this.subscriptionError, "~InternalNotification", notification));
            }
            return;
        }
        if (notification.verb.equals("event")) {
            this.deliverNotification(notification);
        }
    }

    public Subscriber(ONSConfiguration oNSConfiguration, String string, String string2, CallBack callBack) throws ONSException {
        this.id = globalId.getAndIncrement();
        this.subscription = string;
        this.config = oNSConfiguration;
        this.callback = callBack;
        this.callbackMode = callBack == null ? 0 : 2;
        this.componentName = string2;
        this.network = oNSConfiguration.getNetwork();
        this.network.logger.fine("ONS Subscriber " + this + "(" + this.id + ")[network: " + this.network + "]: " + string);
    }

    protected Subscriber(ONSConfiguration oNSConfiguration, String string, String string2, long l) throws ONSException {
        this(oNSConfiguration, string, string2, null);
        if (l == 0L) {
            l = oNSConfiguration.getSocketTimeout();
        }
        this.register(l);
        try {
            this.waitUntilRegistered(l);
        }
        catch (ONSException oNSException) {
            this.close();
            throw oNSException;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.network.logger.fine("ONS Subscriber " + this.id + " registration status: " + this.registered);
    }

    public void register() throws ONSException {
        this.register(this.config.getSocketTimeout());
    }

    public void register(long l) throws ONSException {
        if (l == 0L) {
            l = this.config.getSocketTimeout();
        }
        if (this.state.compareAndSet(0, 1)) {
            this.network.logger.fine("ONS subscriber " + this.id + " register timeout: " + l);
            this.network.demand();
            try {
                this.network.waitUntilOnline(l, true);
            }
            catch (InterruptedException interruptedException) {
                this.network.logger.fine("ONS subscriber " + this.id + " register exception: " + interruptedException.getMessage());
                Thread.currentThread().interrupt();
            }
            this.network.logger.fine("ONS registering " + this.id);
            this.network.registerSubscriber(this);
        }
    }

    public void lazyRegister() {
        if (this.state.compareAndSet(0, 1)) {
            this.network.logger.fine("ONS subscriber " + this.id + " lazy register");
            this.network.demand();
            this.network.logger.fine("ONS registering " + this.id);
            this.network.registerSubscriber(this);
        }
    }

    public static Subscriber backgroundSubscriber(ONSConfiguration oNSConfiguration, String string, CallBack callBack) {
        Subscriber subscriber = new Subscriber(oNSConfiguration, string, "", callBack);
        subscriber.setWantSystemNotifications(true);
        subscriber.lazyRegister();
        return subscriber;
    }

    public static Subscriber backgroundSubscriber(String string, String string2, CallBack callBack) {
        return Subscriber.backgroundSubscriber(new ONSConfiguration(string), string2, callBack);
    }

    public void setWantSystemNotifications(boolean bl) {
        this.wantSystemNotifications = bl;
    }

    public Subscriber(ONS oNS, long l) {
        this(oNS, "!", oNS.getConfiguration().getComponent(), oNS.getConfiguration().getSocketTimeout());
    }

    @Deprecated
    public int register(String string, String string2, long l) throws ONSException {
        return 0;
    }

    public Subscriber(ONS oNS, String string) throws ONSException {
        this(oNS, string, oNS.getConfiguration().getComponent());
    }

    public Subscriber(ONS oNS, String string, String string2) throws ONSException {
        this(oNS, string, string2, oNS.getConfiguration().getSocketTimeout());
    }

    private static ONS getDefaultONS() {
        ONS oNS = ONS.getRunningONS();
        if (oNS == null) {
            oNS = ONS.getONS();
        }
        return oNS;
    }

    @Deprecated
    public Subscriber(String string, String string2) throws ONSException {
        this(Subscriber.getDefaultONS(), string, string2);
    }

    @Deprecated
    public Subscriber(String string, String string2, long l) throws ONSException {
        this(Subscriber.getDefaultONS(), string, string2, l);
    }

    public Subscriber(ONS oNS, String string, String string2, long l) throws ONSException {
        this(oNS.getConfiguration(), string, string2, l);
        oNS.addChildObject(this);
    }

    public Subscriber(ONSConfiguration oNSConfiguration, String string) {
        this(oNSConfiguration, string, oNSConfiguration.getComponent(), null);
        this.register();
    }

    public Subscriber(ONSConfiguration oNSConfiguration, String string, CallBack callBack) {
        this(oNSConfiguration, string, oNSConfiguration.getComponent(), callBack);
        this.register();
    }

    public boolean waitUntilRegistered() throws ONSException, InterruptedException {
        return this.waitUntilRegistered(this.config.getSocketTimeout(), true);
    }

    public boolean waitUntilRegistered(long l) throws ONSException, InterruptedException {
        return this.waitUntilRegistered(l, false);
    }

    public boolean waitUntilRegistered(long l, boolean bl) throws ONSException, InterruptedException {
        if (this.subscriptionStatusLock.availablePermits() == 0) {
            if (this.subscriptionStatusLock.tryAcquire(l, TimeUnit.MILLISECONDS)) {
                this.subscriptionStatusLock.release();
            } else if (bl) {
                throw new SubscriptionException("Subscription time out");
            }
        }
        if (this.subscriptionError != null) {
            ONSException oNSException = this.subscriptionError;
            this.subscriptionError = null;
            throw oNSException;
        }
        return this.registered;
    }

    private Notification internalReceive(boolean bl, long l) {
        if (this.state.get() == 3) {
            return null;
        }
        try {
            Notification notification;
            do {
                Notification notification2 = notification = bl ? this.take() : this.poll(l);
                if (notification != loopbackCloseEvent) continue;
                return null;
            } while (notification != null && notification.isSystemNotification() && !this.wantSystemNotifications);
            return notification;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public Notification take() throws InterruptedException {
        if (this.callback != null) {
            throw new SubscriptionException("Trying to poll a callback subscriber");
        }
        return this.notificationQueue.take();
    }

    public Notification poll(long l) throws InterruptedException {
        if (this.callback != null) {
            throw new SubscriptionException("Trying to poll a callback subscriber");
        }
        return l == 0L ? (Notification)this.notificationQueue.poll() : this.notificationQueue.poll(l, TimeUnit.MILLISECONDS);
    }

    public String getSubscription() {
        return this.subscription;
    }

    public synchronized void register_callback(CallBack callBack, int n) {
        if (this.callback == null) {
            this.callback = callBack;
            this.callbackMode = n;
            if (this.callbackMode == 2) {
                Notification notification;
                ArrayList<Notification> arrayList = new ArrayList<Notification>();
                while ((notification = (Notification)this.notificationQueue.poll()) != null) {
                    if (notification.isSystemNotification() && !this.wantSystemNotifications && !(this.callback instanceof NotificationCallback)) continue;
                    arrayList.add(notification);
                }
                if (!arrayList.isEmpty()) {
                    this.network.master.getWorkloadManager().schedule(new CallCallbackAction(this.callback, arrayList.toArray(new Notification[arrayList.size()])));
                }
            } else if (this.callbackMode == 1 && !this.notificationQueue.isEmpty()) {
                this.network.master.getWorkloadManager().schedule(this.callbackSingleton);
            }
        } else {
            throw new SubscriptionException("Callback already registered");
        }
    }

    protected Message getSubscriptionMessage() {
        return new Message("subscribe").put("Subscription", this.subscription);
    }

    public String toString() {
        return String.format("ONSSubscription : { Subscription : %s; Id : %d }", this.subscription, this.id);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean isClosed() {
        return this.state.get() == 3;
    }

    public String subscription() {
        return this.getSubscription();
    }

    public String component() {
        return this.componentName;
    }

    public synchronized void cancel_callback() throws SubscriptionException {
        this.callbackMode = 0;
        this.callback = null;
    }

    @Deprecated
    public Publisher getPublisher() {
        return new Publisher(this.network, this.componentName);
    }

    @Deprecated
    public int id() {
        return this.id;
    }

    public Notification receive(boolean bl) {
        return this.internalReceive(bl, 0L);
    }

    public Notification receive(long l) {
        return this.internalReceive(false, l);
    }

    @Deprecated
    public int unregister(long l) {
        this.close();
        return 0;
    }

    @Deprecated
    public void relinquish(Notification notification) {
    }

    protected void setServerSubscriberInfo(Node node, String string) {
    }

    private class SingletonCallbackAction
    implements Runnable {
        private volatile boolean running = false;

        private SingletonCallbackAction() {
        }

        public boolean hasCarrier() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SingletonCallbackAction singletonCallbackAction = this;
            synchronized (singletonCallbackAction) {
                Notification notification;
                while ((notification = (Notification)Subscriber.this.notificationQueue.poll()) != null) {
                    this.running = true;
                    if (Subscriber.this.callback != null) {
                        try {
                            if (!notification.isSystemNotification() || Subscriber.this.wantSystemNotifications || Subscriber.this.callback instanceof NotificationCallback) {
                                Subscriber.this.callback.notification_callback(notification);
                            }
                        }
                        catch (Exception exception) {
                            ((Subscriber)Subscriber.this).network.logger.warning(ONS.exceptionMsg(exception));
                        }
                    } else {
                        ((Subscriber)Subscriber.this).network.logger.fine("no callback");
                    }
                    this.running = false;
                }
            }
        }
    }

    private static class CallCallbackAction
    implements Runnable {
        CallBack callback_local;
        Notification[] n;

        private CallCallbackAction(CallBack callBack, Notification notification) {
            this.callback_local = callBack;
            this.n = new Notification[1];
            this.n[0] = notification;
        }

        private CallCallbackAction(CallBack callBack, Notification[] notificationArray) {
            this.callback_local = callBack;
            this.n = notificationArray;
        }

        @Override
        public void run() {
            if (this.callback_local != null) {
                for (Notification notification : this.n) {
                    this.callback_local.notification_callback(notification);
                }
            }
        }
    }
}

