/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions.expression;

import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowConditionProviderFactory;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionBaseVisitor;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParser;

public class BooleanConditionEvaluator
extends BooleanConditionBaseVisitor<Boolean> {
    private final KeycloakSession session;
    private final WorkflowEvent event;
    private final WorkflowsManager manager;

    public BooleanConditionEvaluator(KeycloakSession session, WorkflowEvent event) {
        this.session = session;
        this.event = event;
        this.manager = new WorkflowsManager(session);
    }

    @Override
    public Boolean visitEvaluator(BooleanConditionParser.EvaluatorContext ctx) {
        return (Boolean)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Boolean visitExpression(BooleanConditionParser.ExpressionContext ctx) {
        if (ctx.expression() != null && ctx.OR() != null) {
            return (Boolean)this.visit((ParseTree)ctx.expression()) != false || (Boolean)this.visit((ParseTree)ctx.andExpression()) != false;
        }
        return (Boolean)this.visit((ParseTree)ctx.andExpression());
    }

    @Override
    public Boolean visitAndExpression(BooleanConditionParser.AndExpressionContext ctx) {
        if (ctx.andExpression() != null && ctx.AND() != null) {
            return (Boolean)this.visit((ParseTree)ctx.andExpression()) != false && (Boolean)this.visit((ParseTree)ctx.notExpression()) != false;
        }
        return (Boolean)this.visit((ParseTree)ctx.notExpression());
    }

    @Override
    public Boolean visitNotExpression(BooleanConditionParser.NotExpressionContext ctx) {
        if (ctx.NOT() != null) {
            return (Boolean)this.visit((ParseTree)ctx.notExpression()) == false;
        }
        return (Boolean)this.visit((ParseTree)ctx.atom());
    }

    @Override
    public Boolean visitAtom(BooleanConditionParser.AtomContext ctx) {
        if (ctx.conditionCall() != null) {
            return (Boolean)this.visit((ParseTree)ctx.conditionCall());
        }
        return (Boolean)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Boolean visitConditionCall(BooleanConditionParser.ConditionCallContext ctx) {
        String conditionName = ctx.Identifier().getText();
        WorkflowConditionProviderFactory providerFactory = this.manager.getConditionProviderFactory(conditionName);
        WorkflowConditionProvider conditionProvider = providerFactory.create(this.session, this.extractParameterList(ctx.parameterList()));
        return conditionProvider.evaluate(this.event);
    }

    private List<String> extractParameterList(BooleanConditionParser.ParameterListContext ctx) {
        if (ctx == null) {
            return List.of();
        }
        return ctx.StringLiteral().stream().map(this::visitStringLiteral).collect(Collectors.toList());
    }

    private String visitStringLiteral(ParseTree ctx) {
        String text = ctx.getText();
        return text.substring(1, text.length() - 1).replace("\"\"", "\"");
    }
}

