/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowStateEntity;
import org.keycloak.models.workflow.WorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.utils.StringUtil;

public class JpaWorkflowStateProvider
implements WorkflowStateProvider {
    private final EntityManager em;
    private static final Logger LOGGER = Logger.getLogger(JpaWorkflowStateProvider.class);
    private final KeycloakSession session;

    public JpaWorkflowStateProvider(KeycloakSession session) {
        this.session = session;
        this.em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
    }

    public WorkflowStateProvider.ScheduledStep getScheduledStep(String workflowId, String resourceId) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(WorkflowStateEntity.class);
        Root stateRoot = query.from(WorkflowStateEntity.class);
        query.where((Expression)cb.and((Expression)cb.equal((Expression)stateRoot.get("workflowId"), (Object)workflowId), (Expression)cb.equal((Expression)stateRoot.get("resourceId"), (Object)resourceId)));
        WorkflowStateEntity entity = (WorkflowStateEntity)this.em.createQuery(query).getSingleResultOrNull();
        return entity != null ? this.toScheduledStep(entity) : null;
    }

    public void scheduleStep(Workflow workflow, WorkflowStep step, String resourceId, String executionId) {
        WorkflowStateEntity entity = (WorkflowStateEntity)this.em.find(WorkflowStateEntity.class, (Object)executionId);
        if (entity == null) {
            entity = new WorkflowStateEntity();
            entity.setResourceId(resourceId);
            entity.setWorkflowId(workflow.getId());
            entity.setExecutionId(executionId);
            entity.setWorkflowProviderId(workflow.getProviderId());
            entity.setScheduledStepId(step.getId());
            entity.setScheduledStepTimestamp(Time.currentTimeMillis() + step.getAfter());
            this.em.persist((Object)entity);
        } else {
            entity.setScheduledStepId(step.getId());
            entity.setScheduledStepTimestamp(Time.currentTimeMillis() + step.getAfter());
        }
    }

    public List<WorkflowStateProvider.ScheduledStep> getDueScheduledSteps(Workflow workflow) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(WorkflowStateEntity.class);
        Root stateRoot = query.from(WorkflowStateEntity.class);
        Predicate byWorkflow = cb.equal((Expression)stateRoot.get("workflowId"), (Object)workflow.getId());
        Predicate isExpired = cb.lessThan((Expression)stateRoot.get("scheduledStepTimestamp"), (Comparable)Long.valueOf(Time.currentTimeMillis()));
        query.where((Expression)cb.and((Expression)byWorkflow, (Expression)isExpired));
        return this.em.createQuery(query).getResultStream().map(this::toScheduledStep).toList();
    }

    public List<WorkflowStateProvider.ScheduledStep> getScheduledStepsByWorkflow(String workflowId) {
        if (StringUtil.isBlank((String)workflowId)) {
            return List.of();
        }
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(WorkflowStateEntity.class);
        Root stateRoot = query.from(WorkflowStateEntity.class);
        Predicate byWorkflow = cb.equal((Expression)stateRoot.get("workflowId"), (Object)workflowId);
        query.where((Expression)byWorkflow);
        return this.em.createQuery(query).getResultStream().map(this::toScheduledStep).toList();
    }

    public List<WorkflowStateProvider.ScheduledStep> getScheduledStepsByResource(String resourceId) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(WorkflowStateEntity.class);
        Root stateRoot = query.from(WorkflowStateEntity.class);
        Predicate byResource = cb.equal((Expression)stateRoot.get("resourceId"), (Object)resourceId);
        query.where((Expression)byResource);
        return this.em.createQuery(query).getResultStream().map(this::toScheduledStep).toList();
    }

    public List<WorkflowStateProvider.ScheduledStep> getScheduledStepsByStep(String stepId) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(WorkflowStateEntity.class);
        Root stateRoot = query.from(WorkflowStateEntity.class);
        Predicate byStep = cb.equal((Expression)stateRoot.get("scheduledStepId"), (Object)stepId);
        query.where((Expression)byStep);
        return this.em.createQuery(query).getResultStream().map(this::toScheduledStep).toList();
    }

    public void removeByResource(String resourceId) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(WorkflowStateEntity.class);
        Root root = delete.from(WorkflowStateEntity.class);
        delete.where((Expression)cb.equal((Expression)root.get("resourceId"), (Object)resourceId));
        int deletedCount = this.em.createQuery(delete).executeUpdate();
        if (LOGGER.isTraceEnabled() && deletedCount > 0) {
            LOGGER.tracev("Deleted {0} orphaned state records for resource {1}", (Object)deletedCount, (Object)resourceId);
        }
    }

    public void removeByWorkflow(String workflowId) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(WorkflowStateEntity.class);
        Root root = delete.from(WorkflowStateEntity.class);
        delete.where((Expression)cb.equal((Expression)root.get("workflowId"), (Object)workflowId));
        int deletedCount = this.em.createQuery(delete).executeUpdate();
        if (LOGGER.isTraceEnabled() && deletedCount > 0) {
            RealmModel realm = this.session.getContext().getRealm();
            LOGGER.tracev("Deleted {0} state records for realm {1}", (Object)deletedCount, (Object)realm.getId());
        }
    }

    public void remove(String executionId) {
        WorkflowStateEntity entity = (WorkflowStateEntity)this.em.find(WorkflowStateEntity.class, (Object)executionId);
        if (entity != null) {
            this.em.remove((Object)entity);
        }
    }

    public void removeAll() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(WorkflowStateEntity.class);
        int deletedCount = this.em.createQuery(delete).executeUpdate();
        if (LOGGER.isTraceEnabled() && deletedCount > 0) {
            RealmModel realm = this.session.getContext().getRealm();
            LOGGER.tracev("Deleted {0} state records for realm {1}", (Object)deletedCount, (Object)realm.getId());
        }
    }

    public void close() {
    }

    private WorkflowStateProvider.ScheduledStep toScheduledStep(WorkflowStateEntity entity) {
        return new WorkflowStateProvider.ScheduledStep(entity.getWorkflowId(), entity.getScheduledStepId(), entity.getResourceId(), entity.getExecutionId());
    }
}

