/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.selector.internal;

import java.util.Objects;
import org.hibernate.boot.registry.selector.internal.LazyServiceResolver;
import org.hibernate.engine.transaction.jta.platform.internal.AtomikosJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.GlassFishJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JBossAppServerJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.ResinJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WebSphereLibertyJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WeblogicJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;

public class DefaultJtaPlatformSelector
implements LazyServiceResolver<JtaPlatform> {
    @Override
    public Class<? extends JtaPlatform> resolve(String name) {
        Objects.requireNonNull(name);
        if (name.isBlank()) {
            return null;
        }
        if (name.startsWith("org.")) {
            return DefaultJtaPlatformSelector.legacy(name, this);
        }
        return switch (name) {
            case "JBossAS" -> JBossAppServerJtaPlatform.class;
            case "JBossTS" -> JBossStandAloneJtaPlatform.class;
            case "Weblogic" -> WeblogicJtaPlatform.class;
            case "WebSphere", "WebSphereLiberty" -> WebSphereLibertyJtaPlatform.class;
            case "Atomikos" -> AtomikosJtaPlatform.class;
            case "Resin" -> ResinJtaPlatform.class;
            case "GlassFish", "Payara", "SunOne" -> GlassFishJtaPlatform.class;
            default -> null;
        };
    }

    private static Class<? extends JtaPlatform> legacy(String name, DefaultJtaPlatformSelector defaultJtaPlatformSelector) {
        switch (name) {
            case "org.hibernate.service.jta.platform.internal.JBossAppServerJtaPlatform": {
                return JBossAppServerJtaPlatform.class;
            }
            case "org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform": {
                return JBossStandAloneJtaPlatform.class;
            }
            case "org.hibernate.engine.transaction.jta.platform.internal.WebSphereLibertyJtaPlatform": {
                return WebSphereLibertyJtaPlatform.class;
            }
        }
        String LEGACY_PREFIX = "org.hibernate.service.jta.platform.internal.";
        String LEGACY_POSTFIX = "JtaPlatform";
        if (name.startsWith("org.hibernate.service.jta.platform.internal.") && name.endsWith("JtaPlatform")) {
            String cleanName = name.substring("org.hibernate.service.jta.platform.internal.".length(), name.length() - "JtaPlatform".length());
            return defaultJtaPlatformSelector.resolve(cleanName);
        }
        return null;
    }
}

