/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.Logger;
import twitter4j.StatusStream;
import twitter4j.StatusStreamBase;
import twitter4j.StatusStreamImpl;
import twitter4j.StringUtil;
import twitter4j.TwitterException;
import twitter4j.v1.ConnectionLifeCycleListener;
import twitter4j.v1.FilterQuery;
import twitter4j.v1.RawStreamListener;
import twitter4j.v1.StreamListener;
import twitter4j.v1.TwitterStream;

class TwitterStreamImpl
implements TwitterStream {
    private static final Logger logger = Logger.getLogger();
    private final String streamBaseURL;
    private final String streamThreadName;
    private final List<ConnectionLifeCycleListener> connectionLifeCycleListeners;
    private final List<StreamListener> streamListeners;
    private final List<RawStreamListener> rawStreamListeners;
    private final boolean jsonStoreEnabled;
    private final boolean prettyDebug;
    private TwitterStreamConsumer handler = null;
    private final String stallWarningsGetParam;
    private final HttpParameter stallWarningsParam;
    private final HttpClient http;
    private final Authorization auth;
    private static final int TCP_ERROR_INITIAL_WAIT = 250;
    private static final int TCP_ERROR_WAIT_CAP = 16000;
    private static final int HTTP_ERROR_INITIAL_WAIT = 10000;
    private static final int HTTP_ERROR_WAIT_CAP = 240000;
    private static final int NO_WAIT = 0;
    private static int count = 0;

    TwitterStreamImpl(String streamBaseURL, String streamThreadName, List<ConnectionLifeCycleListener> connectionLifeCycleListeners, List<StreamListener> streamListeners, List<RawStreamListener> rawStreamListeners, boolean jsonStoreEnabled, boolean prettyDebug, boolean stallWarningsEnabled, HttpClient http, Authorization auth) {
        this.streamBaseURL = streamBaseURL;
        this.streamThreadName = streamThreadName;
        this.connectionLifeCycleListeners = connectionLifeCycleListeners;
        this.streamListeners = streamListeners;
        this.rawStreamListeners = rawStreamListeners;
        this.jsonStoreEnabled = jsonStoreEnabled;
        this.prettyDebug = prettyDebug;
        this.stallWarningsGetParam = "stall_warnings=" + (stallWarningsEnabled ? "true" : "false");
        this.stallWarningsParam = new HttpParameter("stall_warnings", stallWarningsEnabled);
        this.http = http;
        http.addDefaultRequestHeader("Connection", "close");
        this.auth = auth;
    }

    @Override
    public TwitterStream firehose(final int count) {
        this.auth.isEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getFirehoseStream(count);
            }
        });
        return this;
    }

    StatusStream getFirehoseStream(int count) throws TwitterException {
        return this.getCountStream("statuses/firehose.json", count);
    }

    @Override
    public TwitterStream links(final int count) {
        this.auth.isEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getLinksStream(count);
            }
        });
        return this;
    }

    StatusStream getLinksStream(int count) throws TwitterException {
        return this.getCountStream("statuses/links.json", count);
    }

    private StatusStream getCountStream(String relativeUrl, int count) throws TwitterException {
        try {
            return new StatusStreamImpl(this.http.post(this.streamBaseURL + relativeUrl, new HttpParameter[]{new HttpParameter("count", String.valueOf(count)), this.stallWarningsParam}, this.auth, null), this.streamListeners, this.rawStreamListeners, this.jsonStoreEnabled, this.prettyDebug);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public TwitterStream retweet() {
        this.auth.isEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getRetweetStream();
            }
        });
        return this;
    }

    StatusStream getRetweetStream() throws TwitterException {
        try {
            return new StatusStreamImpl(this.http.post(this.streamBaseURL + "statuses/retweet.json", new HttpParameter[]{this.stallWarningsParam}, this.auth, null), this.streamListeners, this.rawStreamListeners, this.jsonStoreEnabled, this.prettyDebug);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public TwitterStream sample() {
        this.auth.isEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getSampleStream();
            }
        });
        return this;
    }

    @Override
    public TwitterStream sample(final String language) {
        this.auth.isEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getSampleStream(language);
            }
        });
        return this;
    }

    StatusStream getSampleStream() throws TwitterException {
        try {
            return new StatusStreamImpl(this.http.get(this.streamBaseURL + "statuses/sample.json?" + this.stallWarningsGetParam, null, this.auth, null), this.streamListeners, this.rawStreamListeners, this.jsonStoreEnabled, this.prettyDebug);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    StatusStream getSampleStream(String language) throws TwitterException {
        try {
            return new StatusStreamImpl(this.http.get(this.streamBaseURL + "statuses/sample.json?" + this.stallWarningsGetParam + "&language=" + language, null, this.auth, null), this.streamListeners, this.rawStreamListeners, this.jsonStoreEnabled, this.prettyDebug);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public TwitterStream filter(final FilterQuery query) {
        this.auth.isEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            @Override
            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getFilterStream(query);
            }
        });
        return this;
    }

    StatusStream getFilterStream(FilterQuery query) throws TwitterException {
        try {
            return new StatusStreamImpl(this.http.post(this.streamBaseURL + "statuses/filter.json", this.getParameters(query, this.stallWarningsParam), this.auth, null), this.streamListeners, this.rawStreamListeners, this.jsonStoreEnabled, this.prettyDebug);
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    @NotNull
    private HttpParameter[] getParameters(FilterQuery query, HttpParameter stallWarningsParam) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("count", query.count));
        if (query.follow != null && query.follow.length > 0) {
            params.add(new HttpParameter("follow", StringUtil.join(query.follow)));
        }
        if (query.track != null && query.track.length > 0) {
            params.add(new HttpParameter("track", StringUtil.join(query.track)));
        }
        if (query.locations != null && query.locations.length > 0) {
            params.add(new HttpParameter("locations", this.toLocationsString(query.locations)));
        }
        if (query.language != null && query.language.length > 0) {
            params.add(new HttpParameter("language", StringUtil.join(query.language)));
        }
        if (query.filterLevel != null) {
            params.add(new HttpParameter("filter_level", query.filterLevel.name().toLowerCase()));
        }
        params.add(stallWarningsParam);
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private String toLocationsString(double[][] keywords) {
        StringBuilder buf = new StringBuilder(20 * keywords.length * 2);
        for (double[] keyword : keywords) {
            if (0 != buf.length()) {
                buf.append(",");
            }
            buf.append(keyword[0]);
            buf.append(",");
            buf.append(keyword[1]);
        }
        return buf.toString();
    }

    private void ensureStatusStreamListenerIsSet() {
        if (this.streamListeners.size() == 0 && this.rawStreamListeners.size() == 0) {
            throw new IllegalStateException("StatusListener is not set.");
        }
    }

    private synchronized void startHandler(TwitterStreamConsumer handler) {
        this.cleanUp();
        this.handler = handler;
        this.handler.start();
    }

    @Override
    public synchronized void cleanUp() {
        if (this.handler != null) {
            this.handler.close();
        }
    }

    @Override
    public synchronized void shutdown() {
        this.cleanUp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterStreamImpl that = (TwitterStreamImpl)o;
        return Objects.equals(this.streamThreadName, that.streamThreadName) && Objects.equals(this.auth, that.auth);
    }

    public int hashCode() {
        return Objects.hash(this.streamThreadName, this.auth);
    }

    public String toString() {
        return "TwitterStreamImpl{streamBaseURL='" + this.streamBaseURL + '\'' + ", streamThreadName='" + this.streamThreadName + '\'' + ", connectionLifeCycleListeners=" + this.connectionLifeCycleListeners + ", streamListeners=" + this.streamListeners + ", rawStreamListeners=" + this.rawStreamListeners + ", jsonStoreEnabled=" + this.jsonStoreEnabled + ", prettyDebug=" + this.prettyDebug + ", handler=" + this.handler + ", stallWarningsGetParam='" + this.stallWarningsGetParam + '\'' + ", stallWarningsParam=" + this.stallWarningsParam + ", http=" + this.http + ", auth=" + this.auth + '}';
    }

    abstract class TwitterStreamConsumer
    extends Thread {
        private StatusStreamBase stream = null;
        private final String NAME;
        private volatile boolean closed = false;
        private final Mode mode;

        TwitterStreamConsumer(Mode mode) {
            this.mode = mode;
            this.NAME = String.format("Twitter Stream consumer / %s [%s]", TwitterStreamImpl.this.streamThreadName, ++count);
            this.setName(this.NAME + "[initializing]");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int timeToSleep = 0;
            boolean connected = false;
            block14: while (!this.closed) {
                try {
                    if (this.closed || null != this.stream) continue;
                    logger.info("Establishing connection.");
                    this.setStatus("[Establishing connection]");
                    this.stream = (StatusStreamBase)this.getStream();
                    connected = true;
                    logger.info("Connection established.");
                    TwitterStreamImpl.this.connectionLifeCycleListeners.forEach(e -> {
                        try {
                            e.onConnect();
                        }
                        catch (Exception ex) {
                            logger.warn(ex.getMessage());
                        }
                    });
                    timeToSleep = 0;
                    logger.info("Receiving status stream.");
                    this.setStatus("[Receiving stream]");
                    while (!this.closed) {
                        try {
                            this.stream.next(TwitterStreamImpl.this.streamListeners, TwitterStreamImpl.this.rawStreamListeners);
                        }
                        catch (IllegalStateException ise) {
                            logger.warn(ise.getMessage());
                            continue block14;
                        }
                        catch (TwitterException e2) {
                            logger.info(e2.getMessage());
                            this.stream.onException(e2);
                            throw e2;
                        }
                        catch (Exception e3) {
                            if (e3 instanceof NullPointerException || "Inflater has been closed".equals(e3.getMessage())) continue;
                            logger.info(e3.getMessage());
                            this.stream.onException(e3);
                            this.closed = true;
                        }
                    }
                }
                catch (TwitterException te) {
                    logger.info(te.getMessage());
                    if (this.closed) continue;
                    if (0 == timeToSleep) {
                        if (te.getStatusCode() == 403) {
                            logger.warn("This account is not in required role. ", te.getMessage());
                            this.closed = true;
                            this.stream.onException(te);
                            break;
                        }
                        if (te.getStatusCode() == 406) {
                            logger.warn("Parameter not accepted with the role. ", te.getMessage());
                            this.closed = true;
                            this.stream.onException(te);
                            break;
                        }
                        connected = false;
                        TwitterStreamImpl.this.connectionLifeCycleListeners.forEach(listener -> {
                            try {
                                listener.onDisconnect();
                            }
                            catch (Exception ex) {
                                logger.warn(ex.getMessage());
                            }
                        });
                        timeToSleep = te.getStatusCode() > 200 ? 10000 : 250;
                    }
                    if (te.getStatusCode() > 200 && timeToSleep < 10000) {
                        timeToSleep = 10000;
                    }
                    TwitterStreamImpl.this.streamListeners.forEach(listener -> {
                        try {
                            listener.onException(te);
                        }
                        catch (Exception ex) {
                            logger.warn(ex.getMessage());
                        }
                    });
                    if (!this.closed) {
                        logger.info("Waiting for " + timeToSleep + " milliseconds");
                        this.setStatus("[Waiting for " + timeToSleep + " milliseconds]");
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        timeToSleep = Math.min(timeToSleep * 2, te.getStatusCode() > 200 ? 240000 : 16000);
                    }
                    this.stream = null;
                    logger.debug(te.getMessage());
                    connected = false;
                }
            }
            if (this.stream != null && connected) {
                try {
                    this.stream.close();
                }
                catch (IOException te) {
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                    logger.warn(e4.getMessage());
                }
                finally {
                    TwitterStreamImpl.this.connectionLifeCycleListeners.forEach(listener -> {
                        try {
                            listener.onDisconnect();
                        }
                        catch (Exception ex) {
                            logger.warn(ex.getMessage());
                        }
                    });
                }
            }
            TwitterStreamImpl.this.connectionLifeCycleListeners.forEach(listener -> {
                try {
                    listener.onCleanUp();
                }
                catch (Exception ex) {
                    logger.warn(ex.getMessage());
                }
            });
        }

        public synchronized void close() {
            this.setStatus("[Disposing thread]");
            this.closed = true;
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.warn(e.getMessage());
                }
            }
        }

        private void setStatus(String message) {
            String actualMessage = this.NAME + message;
            this.setName(actualMessage);
            logger.debug(actualMessage);
        }

        abstract StatusStream getStream() throws TwitterException;
    }

    static enum Mode {
        user,
        status;

    }
}

