/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.resteasy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.handlers.FormBodyHandler;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.keycloak.quarkus.runtime.integration.resteasy.SetResponseContentTypeHandler;
import org.keycloak.quarkus.runtime.integration.resteasy.TransactionalSessionHandler;

public final class KeycloakHandlerChainCustomizer
implements HandlerChainCustomizer {
    private final TransactionalSessionHandler TRANSACTIONAL_SESSION_HANDLER = new TransactionalSessionHandler();
    private final FormBodyHandler formBodyHandler = new FormBodyHandler(true, () -> Runnable::run, Set.of());

    public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod resourceMethod) {
        ArrayList<ServerRestHandler> handlers = new ArrayList<ServerRestHandler>();
        switch (phase) {
            case BEFORE_METHOD_INVOKE: {
                if (!resourceMethod.isFormParamRequired() && ("PATCH".equalsIgnoreCase(resourceMethod.getHttpMethod()) || "POST".equalsIgnoreCase(resourceMethod.getHttpMethod()) || "PUT".equalsIgnoreCase(resourceMethod.getHttpMethod()))) {
                    handlers.add((ServerRestHandler)this.formBodyHandler);
                }
                handlers.add(this.TRANSACTIONAL_SESSION_HANDLER);
                break;
            }
            case AFTER_METHOD_INVOKE: {
                handlers.add(new SetResponseContentTypeHandler(resourceMethod.getProduces()));
            }
        }
        return handlers;
    }
}

