/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.immutable.pcollections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.kafka.server.immutable.ImmutableNavigableSet;
import org.pcollections.TreePSet;

public class PCollectionsImmutableNavigableSet<E>
implements ImmutableNavigableSet<E> {
    private final TreePSet<E> underlying;

    public static <E extends Comparable<? super E>> PCollectionsImmutableNavigableSet<E> empty() {
        return new PCollectionsImmutableNavigableSet<E>(TreePSet.empty());
    }

    public static <E extends Comparable<? super E>> PCollectionsImmutableNavigableSet<E> singleton(E e) {
        return new PCollectionsImmutableNavigableSet<E>(TreePSet.singleton(e));
    }

    public PCollectionsImmutableNavigableSet(TreePSet<E> underlying) {
        this.underlying = underlying;
    }

    @Override
    public PCollectionsImmutableNavigableSet<E> added(E e) {
        return new PCollectionsImmutableNavigableSet<E>(this.underlying().plus(e));
    }

    @Override
    public PCollectionsImmutableNavigableSet<E> removed(E e) {
        return new PCollectionsImmutableNavigableSet<E>(this.underlying().minus(e));
    }

    @Override
    public E lower(E e) {
        return (E)this.underlying().lower(e);
    }

    @Override
    public E floor(E e) {
        return (E)this.underlying().floor(e);
    }

    @Override
    public E ceiling(E e) {
        return (E)this.underlying().ceiling(e);
    }

    @Override
    public E higher(E e) {
        return (E)this.underlying().higher(e);
    }

    @Override
    public E pollFirst() {
        return (E)this.underlying().pollFirst();
    }

    @Override
    public E pollLast() {
        return (E)this.underlying().pollLast();
    }

    @Override
    public PCollectionsImmutableNavigableSet<E> descendingSet() {
        return new PCollectionsImmutableNavigableSet<E>(this.underlying().descendingSet());
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.underlying().descendingIterator();
    }

    @Override
    public PCollectionsImmutableNavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new PCollectionsImmutableNavigableSet<E>(this.underlying().subSet(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public PCollectionsImmutableNavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new PCollectionsImmutableNavigableSet<E>(this.underlying().headSet(toElement, inclusive));
    }

    @Override
    public PCollectionsImmutableNavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new PCollectionsImmutableNavigableSet<E>(this.underlying().tailSet(fromElement, inclusive));
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.underlying().comparator();
    }

    @Override
    public PCollectionsImmutableNavigableSet<E> subSet(E fromElement, E toElement) {
        return new PCollectionsImmutableNavigableSet<E>(this.underlying().subSet(fromElement, toElement));
    }

    @Override
    public PCollectionsImmutableNavigableSet<E> headSet(E toElement) {
        return new PCollectionsImmutableNavigableSet<E>(this.underlying().headSet(toElement));
    }

    @Override
    public PCollectionsImmutableNavigableSet<E> tailSet(E fromElement) {
        return new PCollectionsImmutableNavigableSet<E>(this.underlying().tailSet(fromElement));
    }

    @Override
    public E first() {
        return (E)this.underlying().first();
    }

    @Override
    public E last() {
        return (E)this.underlying().last();
    }

    @Override
    public int size() {
        return this.underlying().size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlying().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.underlying().iterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.underlying().forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.underlying().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.underlying().toArray((Object[])a);
    }

    @Override
    public boolean add(E e) {
        return this.underlying().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.underlying().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.underlying().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.underlying().addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.underlying().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.underlying().removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.underlying().removeIf(filter);
    }

    @Override
    public void clear() {
        this.underlying().clear();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.underlying().spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.underlying().stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.underlying().parallelStream();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PCollectionsImmutableNavigableSet that = (PCollectionsImmutableNavigableSet)o;
        return Objects.equals(this.underlying(), that.underlying());
    }

    @Override
    public int hashCode() {
        return this.underlying().hashCode();
    }

    public String toString() {
        return "PCollectionsImmutableNavigableSet{underlying=" + String.valueOf(this.underlying()) + "}";
    }

    TreePSet<E> underlying() {
        return this.underlying;
    }
}

