/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.module.blackbird.deser.ObjBooleanConsumer;
import com.fasterxml.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;
import java.io.IOException;

final class SettableBooleanProperty
extends OptimizedSettableBeanProperty<SettableBooleanProperty> {
    private static final long serialVersionUID = 1L;
    private ObjBooleanConsumer _optimizedSetter;

    public SettableBooleanProperty(SettableBeanProperty src, ObjBooleanConsumer optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableBooleanProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        boolean b;
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            b = true;
        } else if (t == JsonToken.VALUE_FALSE) {
            b = false;
        } else {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        try {
            this._optimizedSetter.accept(bean, b);
        }
        catch (Throwable e) {
            this._reportProblem(bean, b, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return this.setAndReturn(instance, Boolean.TRUE);
        }
        if (t == JsonToken.VALUE_FALSE) {
            return this.setAndReturn(instance, Boolean.FALSE);
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(Object bean, Object value) throws IOException {
        boolean b = (Boolean)value;
        try {
            this._optimizedSetter.accept(bean, b);
        }
        catch (Throwable e) {
            this._reportProblem(bean, b, e);
        }
    }
}

