/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.TopicRecord;

public class TopicRecordJsonConverter {
    public static TopicRecord read(JsonNode _node, short _version) {
        TopicRecord _object = new TopicRecord();
        JsonNode _nameNode = _node.get("name");
        if (_nameNode == null) {
            throw new RuntimeException("TopicRecord: unable to locate field 'name', which is mandatory in version " + _version);
        }
        if (!_nameNode.isTextual()) {
            throw new RuntimeException("TopicRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.name = _nameNode.asText();
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("TopicRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("TopicRecord expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        return _object;
    }

    public static JsonNode write(TopicRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("name", (JsonNode)new TextNode(_object.name));
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        return _node;
    }

    public static JsonNode write(TopicRecord _object, short _version) {
        return TopicRecordJsonConverter.write(_object, _version, true);
    }
}

