/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.PrivateMembersLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PrivateMemberBodiesLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class PrivateMemberBodiesLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public PrivateMemberBodiesLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        irBody.transform((IrTransformer)new IrElementTransformerVoid(){

            /*
             * Enabled aggressive block sorting
             */
            public IrExpression visitCall(IrCall expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitCall(expression2);
                IrSimpleFunction irSimpleFunction = PrivateMembersLoweringKt.access$getCorrespondingStatic(expression2.getSymbol().getOwner());
                if (irSimpleFunction != null) {
                    IrSimpleFunction it = irSimpleFunction;
                    boolean bl = false;
                    IrCall irCall = this.transformPrivateToStaticCall(expression2, it);
                    irSimpleFunction = irCall;
                    if (irCall != null) {
                        irExpression = (IrExpression)irSimpleFunction;
                        return irExpression;
                    }
                }
                irExpression = (IrExpression)expression2;
                return irExpression;
            }

            private final IrCall transformPrivateToStaticCall(IrCall expression2, IrSimpleFunction staticTarget) {
                IrCallImpl newExpression = BuildersKt.IrCallImpl((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrType)expression2.getType(), (IrSimpleFunctionSymbol)staticTarget.getSymbol(), (int)expression2.getTypeArguments().size(), (IrStatementOrigin)expression2.getOrigin(), (IrClassSymbol)expression2.getSuperQualifierSymbol());
                AddToStdlibKt.assignFrom((List)((List)newExpression.getArguments()), (Collection)((Collection)expression2.getArguments()));
                IrExpressionsKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)((IrMemberAccessExpression)newExpression), (IrMemberAccessExpression)((IrMemberAccessExpression)expression2), (int)0, (int)2, null);
                return (IrCall)newExpression;
            }
        }, null);
    }
}

