/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.KTypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRowKt;
import org.jetbrains.kotlinx.dataframe.api.AddDataRow;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnDescription;
import org.jetbrains.kotlinx.dataframe.api.ColumnReferenceApiKt;
import org.jetbrains.kotlinx.dataframe.api.ConcatKt;
import org.jetbrains.kotlinx.dataframe.api.CreateDataFrameDsl;
import org.jetbrains.kotlinx.dataframe.api.DataColumnTypeKt;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.MapKt;
import org.jetbrains.kotlinx.dataframe.api.MaxKt;
import org.jetbrains.kotlinx.dataframe.api.MeanKt;
import org.jetbrains.kotlinx.dataframe.api.MedianKt;
import org.jetbrains.kotlinx.dataframe.api.MinKt;
import org.jetbrains.kotlinx.dataframe.api.MoveKt;
import org.jetbrains.kotlinx.dataframe.api.PercentileKt;
import org.jetbrains.kotlinx.dataframe.api.StdKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumnKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.impl.NumberTypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.api.DescribeKt;
import org.jetbrains.kotlinx.dataframe.impl.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnInternalKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0005j\u0002`\u00060\u0004H\u0000\u001a0\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0005j\u0002`\u00060\u0004*\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0005j\u0002`\u00060\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\n\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0018\u00010\u0005*\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0005H\u0002\u00a8\u0006\r"}, d2={"describeImpl", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnDescription;", "cols", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "collectAll", "atAnyDepth", "", "convertToComparableOrNull", "", "", "core"})
@SourceDebugExtension(value={"SMAP\ndescribe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 describe.kt\norg/jetbrains/kotlinx/dataframe/impl/api/DescribeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 toDataFrame.kt\norg/jetbrains/kotlinx/dataframe/api/ToDataFrameKt\n+ 4 add.kt\norg/jetbrains/kotlinx/dataframe/api/AddKt\n+ 5 map.kt\norg/jetbrains/kotlinx/dataframe/api/MapKt\n+ 6 toDataFrame.kt\norg/jetbrains/kotlinx/dataframe/api/CreateDataFrameDsl\n+ 7 typeConversions.kt\norg/jetbrains/kotlinx/dataframe/api/TypeConversionsKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 9 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1761#2,3:131\n1761#2,3:134\n1761#2,3:137\n1374#2:147\n1460#2,2:148\n1563#2:150\n1634#2,3:151\n1563#2:154\n1634#2,3:155\n1462#2,3:158\n1563#2:166\n1634#2,3:167\n1563#2:177\n1634#2,3:178\n1563#2:188\n1634#2,3:189\n1563#2:199\n1634#2,3:200\n1563#2:210\n1634#2,3:211\n1563#2:221\n1634#2,3:222\n1563#2:232\n1634#2,3:233\n1563#2:238\n1634#2,3:239\n1563#2:249\n1634#2,3:250\n1563#2:260\n1634#2,3:261\n1563#2:266\n1634#2,3:267\n1563#2:272\n1634#2,3:273\n1563#2:278\n1634#2,3:279\n1563#2:284\n1634#2,3:285\n1788#2,4:288\n1491#2:292\n1516#2,3:293\n1519#2,3:303\n1788#2,4:307\n45#3:140\n184#4,5:141\n112#5:146\n38#5,3:161\n210#6:164\n202#6:165\n210#6:175\n202#6:176\n210#6:186\n202#6:187\n210#6:197\n202#6:198\n210#6:208\n202#6:209\n210#6:219\n202#6:220\n223#6:230\n219#6:231\n210#6:236\n202#6:237\n210#6:247\n202#6:248\n223#6:258\n219#6:259\n223#6:264\n219#6:265\n223#6:270\n219#6:271\n223#6:276\n219#6:277\n223#6:282\n219#6:283\n329#7,5:170\n329#7,5:181\n329#7,5:192\n329#7,5:203\n329#7,5:214\n329#7,5:225\n329#7,5:242\n329#7,5:253\n382#8,7:296\n1#9:306\n*S KotlinDebug\n*F\n+ 1 describe.kt\norg/jetbrains/kotlinx/dataframe/impl/api/DescribeKt\n*L\n40#1:131,3\n41#1:134,3\n42#1:137,3\n89#1:147\n89#1:148,2\n95#1:150\n95#1:151,3\n102#1:154\n102#1:155,3\n89#1:158,3\n44#1:166\n44#1:167,3\n46#1:177\n46#1:178,3\n48#1:188\n48#1:189,3\n49#1:199\n49#1:200,3\n50#1:210\n50#1:211,3\n51#1:221\n51#1:222,3\n52#1:232\n52#1:233,3\n58#1:238\n58#1:239,3\n59#1:249\n59#1:250,3\n62#1:260\n62#1:261,3\n65#1:266\n65#1:267,3\n68#1:272\n68#1:273,3\n71#1:278\n71#1:279,3\n74#1:284\n74#1:285,3\n51#1:288,4\n54#1:292\n54#1:293,3\n54#1:303,3\n82#1:307,4\n43#1:140\n79#1:141,5\n79#1:146\n119#1:161,3\n44#1:164\n44#1:165\n46#1:175\n46#1:176\n48#1:186\n48#1:187\n49#1:197\n49#1:198\n50#1:208\n50#1:209\n51#1:219\n51#1:220\n52#1:230\n52#1:231\n58#1:236\n58#1:237\n59#1:247\n59#1:248\n62#1:258\n62#1:259\n65#1:264\n65#1:265\n68#1:270\n68#1:271\n71#1:276\n71#1:277\n74#1:282\n74#1:283\n44#1:170,5\n46#1:181,5\n48#1:192,5\n49#1:203,5\n50#1:214,5\n51#1:225,5\n58#1:242,5\n59#1:253,5\n54#1:296,7\n*E\n"})
public final class DescribeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataFrame<ColumnDescription> describeImpl(@NotNull List<? extends DataColumn<?>> cols) {
        void infer$iv$iv;
        void column$iv$iv;
        void $this$mapToColumn$iv$iv;
        void property$iv;
        void $this$add_u24default$iv;
        DataFrame $this$toDataFrame$iv;
        DataFrame df2;
        boolean bl;
        boolean hasComparableCols;
        boolean hasNumericCols;
        List<DataColumn<?>> allCols;
        block11: {
            boolean bl2;
            block10: {
                boolean bl3;
                block9: {
                    Intrinsics.checkNotNullParameter(cols, (String)"cols");
                    allCols = DescribeKt.collectAll(cols, false);
                    Iterable $this$any$iv = allCols;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DataColumn it = (DataColumn)element$iv;
                            boolean bl4 = false;
                            if (!DataColumnTypeKt.isNumber(it)) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                }
                hasNumericCols = bl3;
                Iterable $this$any$iv = allCols;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DataColumn it = (DataColumn)element$iv;
                        boolean bl5 = false;
                        if (!DataColumnTypeKt.valuesAreComparable(it)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            hasComparableCols = bl2;
            Iterable $this$any$iv = allCols;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DataColumn it = (DataColumn)element$iv;
                    boolean bl6 = false;
                    if (!(it.path().size() > 1)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean hasLongPaths = bl;
        Iterable $i$f$any = allCols;
        Function1 body$iv = arg_0 -> DescribeKt.describeImpl$lambda$3(hasLongPaths, hasNumericCols, hasComparableCols, arg_0);
        boolean $i$f$toDataFrame = false;
        $this$toDataFrame$iv = df2 = ToDataFrameKt.createDataFrameImpl($this$toDataFrame$iv, Reflection.getOrCreateKotlinClass(DataColumn.class), body$iv);
        body$iv = (KProperty)describeImpl.1.INSTANCE;
        Function2 expression$iv = (arg_0, arg_1) -> DescribeKt.describeImpl$lambda$4(allCols, arg_0, arg_1);
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$add = false;
        ColumnsContainer columnsContainer = (ColumnsContainer)$this$add_u24default$iv;
        void var12_24 = property$iv;
        Infer infer = infer$iv;
        Function2 body$iv$iv = expression$iv;
        boolean $i$f$mapToColumn = false;
        KProperty[] kPropertyArray = new KProperty[]{describeImpl.3.INSTANCE};
        df2 = MoveKt.after(MoveKt.move($this$add_u24default$iv.plus(MapKt.mapToColumn($this$mapToColumn$iv$iv, column$iv$iv, Reflection.typeOf(Integer.TYPE), (Infer)infer$iv$iv, body$iv$iv)), kPropertyArray), (KProperty)describeImpl.4.INSTANCE);
        return CastKt.cast(df2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<DataColumn<?>> collectAll(List<? extends DataColumn<?>> $this$collectAll, boolean atAnyDepth) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$collectAll;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<DataColumn<?>> list;
            DataColumn col = (DataColumn)element$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[DataColumnKt.getKind(col).ordinal()]) {
                case 1: {
                    DataColumn it;
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    Iterable iterable2 = ConcatKt.concat((DataColumn)org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.asAnyFrameColumn(col)).columns();
                    boolean $i$f$map = false;
                    Iterable iterable3 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        DataColumn dataColumn = (DataColumn)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.addPath(it, col.path().plus(ColumnReferenceApiKt.getName(it))));
                    }
                    list = DescribeKt.collectAll((List)destination$iv$iv2, true);
                    break;
                }
                case 2: {
                    DataColumn it;
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    boolean $i$f$mapTo;
                    Collection destination$iv$iv2;
                    Iterable $this$map$iv;
                    boolean $i$f$map;
                    if (atAnyDepth) {
                        $this$map$iv = TypeConversionsKt.asColumnGroupUntyped(col).columns();
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (DataColumn)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl3 = false;
                            collection.add(org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.addPath(it, col.path().plus(ColumnReferenceApiKt.getName(it))));
                        }
                        list = DescribeKt.collectAll((List)destination$iv$iv2, true);
                        break;
                    }
                    list = CollectionsKt.listOf((Object)col);
                    break;
                }
                case 3: {
                    list = CollectionsKt.listOf((Object)col);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final DataColumn<Comparable<Object>> convertToComparableOrNull(DataColumn<? extends Object> $this$convertToComparableOrNull) {
        DataColumn<Comparable<Object>> dataColumn;
        if (DataColumnTypeKt.valuesAreComparable($this$convertToComparableOrNull)) {
            dataColumn = TypeConversionsKt.asComparableNullable($this$convertToComparableOrNull);
        } else if (DataColumnTypeKt.isNumber($this$convertToComparableOrNull)) {
            DataColumn $this$map_u24default$iv = CastKt.cast($this$convertToComparableOrNull);
            Infer infer$iv = Infer.Nulls;
            boolean $i$f$map = false;
            int n = $this$map_u24default$iv.size();
            Object[] objectArray = new Comparable[n];
            for (int i = 0; i < n; ++i) {
                void it;
                int n2 = i;
                Number number = (Number)$this$map_u24default$iv.get(n2);
                int n3 = n2;
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                void v1 = it;
                boolean bl2 = v1 != null ? !NumberTypeUtilsKt.isPrimitiveNumber((Number)v1) : false;
                if (bl2) {
                    return null;
                }
                void v3 = it;
                Comparable comparable = v3 != null ? Double.valueOf(v3.doubleValue()) : null;
                objectArray2[n3] = comparable;
            }
            List newValues$iv = ArraysKt.asList((Object[])objectArray);
            dataColumn = DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.nullableTypeOf(Comparable.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Object.class))), infer$iv);
        } else {
            dataColumn = null;
        }
        return dataColumn;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit describeImpl$lambda$3(boolean $hasLongPaths, boolean $hasNumericCols, boolean $hasComparableCols, CreateDataFrameDsl $this$toDataFrame) {
        Iterator it$iv;
        CreateDataFrameDsl inferType$iv;
        CreateDataFrameDsl $this$mapTo$iv$iv$iv;
        CreateDataFrameDsl $this$map$iv$iv;
        Iterable $this$toColumn$iv$iv$iv;
        void name$iv$iv$iv;
        String name$iv$iv;
        Object it$iv$iv;
        boolean bl;
        Collection collection;
        Object item$iv$iv$iv$iv;
        void $this$mapTo$iv$iv$iv$iv;
        Iterable $this$map$iv$iv$iv;
        CreateDataFrameDsl this_$iv$iv;
        KProperty $this$from$iv;
        CreateDataFrameDsl this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toDataFrame, (String)"$this$toDataFrame");
        CreateDataFrameDsl createDataFrameDsl = $this$toDataFrame;
        KProperty kProperty = (KProperty)describeImpl.df.1.1.INSTANCE;
        Object expression$iv = DescribeKt::describeImpl$lambda$3$0;
        boolean $i$f$from = false;
        void var8_20 = this_$iv;
        String string = UtilsKt.getColumnName($this$from$iv);
        Object expression$iv$iv = expression$iv;
        boolean $i$f$add = false;
        Iterable iterable = this_$iv$iv.getSource();
        CreateDataFrameDsl createDataFrameDsl2 = this_$iv$iv;
        boolean $i$f$map22 = false;
        void var15_58 = $this$map$iv$iv$iv;
        Collection destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = item$iv$iv$iv$iv = iterator2.next();
            collection = destination$iv$iv$iv$iv;
            bl = false;
            collection.add(expression$iv$iv.invoke(it$iv$iv));
        }
        $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
        String $i$f$map22 = name$iv$iv;
        Object infer$iv$iv$iv = Infer.Nulls;
        boolean $i$f$toColumn = false;
        CreateDataFrameDsl.add$default(createDataFrameDsl2, DataColumnInternalKt.forceResolve(infer$iv$iv$iv == Infer.Type ? DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), null, null, 12, null) : DataColumn.Companion.createByType((String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), Reflection.typeOf(String.class), (Infer)((Object)infer$iv$iv$iv))), null, 2, null);
        if ($hasLongPaths) {
            this_$iv = $this$toDataFrame;
            $this$from$iv = (KProperty)describeImpl.df.1.3.INSTANCE;
            expression$iv = DescribeKt::describeImpl$lambda$3$1;
            $i$f$from = false;
            this_$iv$iv = this_$iv;
            name$iv$iv = UtilsKt.getColumnName($this$from$iv);
            expression$iv$iv = expression$iv;
            $i$f$add = false;
            $this$toColumn$iv$iv$iv = this_$iv$iv.getSource();
            createDataFrameDsl2 = this_$iv$iv;
            boolean $i$f$map = false;
            infer$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                it$iv$iv = item$iv$iv$iv$iv = iterator2.next();
                collection = destination$iv$iv$iv$iv;
                bl = false;
                collection.add(expression$iv$iv.invoke(it$iv$iv));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map22 = name$iv$iv;
            infer$iv$iv$iv = Infer.Nulls;
            $i$f$toColumn = false;
            CreateDataFrameDsl.add$default(createDataFrameDsl2, DataColumnInternalKt.forceResolve(infer$iv$iv$iv == Infer.Type ? DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), null, null, 12, null) : DataColumn.Companion.createByType((String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), Reflection.typeOf(ColumnPath.class), (Infer)((Object)infer$iv$iv$iv))), null, 2, null);
        }
        this_$iv = $this$toDataFrame;
        $this$from$iv = (KProperty)describeImpl.df.1.5.INSTANCE;
        expression$iv = DescribeKt::describeImpl$lambda$3$2;
        $i$f$from = false;
        this_$iv$iv = this_$iv;
        name$iv$iv = UtilsKt.getColumnName($this$from$iv);
        expression$iv$iv = expression$iv;
        $i$f$add = false;
        $this$toColumn$iv$iv$iv = this_$iv$iv.getSource();
        createDataFrameDsl2 = this_$iv$iv;
        boolean $i$f$map32 = false;
        infer$iv$iv$iv = $this$map$iv$iv$iv;
        destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            it$iv$iv = item$iv$iv$iv$iv = iterator2.next();
            collection = destination$iv$iv$iv$iv;
            bl = false;
            collection.add(expression$iv$iv.invoke(it$iv$iv));
        }
        $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
        String $i$f$map32 = name$iv$iv;
        infer$iv$iv$iv = Infer.Nulls;
        $i$f$toColumn = false;
        CreateDataFrameDsl.add$default(createDataFrameDsl2, DataColumnInternalKt.forceResolve(infer$iv$iv$iv == Infer.Type ? DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), null, null, 12, null) : DataColumn.Companion.createByType((String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), Reflection.typeOf(String.class), (Infer)((Object)infer$iv$iv$iv))), null, 2, null);
        this_$iv = $this$toDataFrame;
        $this$from$iv = (KProperty)describeImpl.df.1.7.INSTANCE;
        expression$iv = DescribeKt::describeImpl$lambda$3$3;
        $i$f$from = false;
        this_$iv$iv = this_$iv;
        name$iv$iv = UtilsKt.getColumnName($this$from$iv);
        expression$iv$iv = expression$iv;
        $i$f$add = false;
        $this$toColumn$iv$iv$iv = this_$iv$iv.getSource();
        createDataFrameDsl2 = this_$iv$iv;
        boolean $i$f$map42 = false;
        infer$iv$iv$iv = $this$map$iv$iv$iv;
        destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            it$iv$iv = item$iv$iv$iv$iv = iterator2.next();
            collection = destination$iv$iv$iv$iv;
            bl = false;
            collection.add(expression$iv$iv.invoke(it$iv$iv));
        }
        $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
        String $i$f$map42 = name$iv$iv;
        infer$iv$iv$iv = Infer.Nulls;
        $i$f$toColumn = false;
        CreateDataFrameDsl.add$default(createDataFrameDsl2, DataColumnInternalKt.forceResolve(infer$iv$iv$iv == Infer.Type ? DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), null, null, 12, null) : DataColumn.Companion.createByType((String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), Reflection.typeOf(Integer.TYPE), (Infer)((Object)infer$iv$iv$iv))), null, 2, null);
        this_$iv = $this$toDataFrame;
        $this$from$iv = (KProperty)describeImpl.df.1.9.INSTANCE;
        expression$iv = DescribeKt::describeImpl$lambda$3$4;
        $i$f$from = false;
        this_$iv$iv = this_$iv;
        name$iv$iv = UtilsKt.getColumnName($this$from$iv);
        expression$iv$iv = expression$iv;
        $i$f$add = false;
        $this$toColumn$iv$iv$iv = this_$iv$iv.getSource();
        createDataFrameDsl2 = this_$iv$iv;
        boolean $i$f$map52 = false;
        infer$iv$iv$iv = $this$map$iv$iv$iv;
        destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            it$iv$iv = item$iv$iv$iv$iv = iterator2.next();
            collection = destination$iv$iv$iv$iv;
            bl = false;
            collection.add(expression$iv$iv.invoke(it$iv$iv));
        }
        $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
        String $i$f$map52 = name$iv$iv;
        infer$iv$iv$iv = Infer.Nulls;
        $i$f$toColumn = false;
        CreateDataFrameDsl.add$default(createDataFrameDsl2, DataColumnInternalKt.forceResolve(infer$iv$iv$iv == Infer.Type ? DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), null, null, 12, null) : DataColumn.Companion.createByType((String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), Reflection.typeOf(Integer.TYPE), (Infer)((Object)infer$iv$iv$iv))), null, 2, null);
        this_$iv = $this$toDataFrame;
        $this$from$iv = (KProperty)describeImpl.df.1.11.INSTANCE;
        expression$iv = DescribeKt::describeImpl$lambda$3$5;
        $i$f$from = false;
        this_$iv$iv = this_$iv;
        name$iv$iv = UtilsKt.getColumnName($this$from$iv);
        expression$iv$iv = expression$iv;
        $i$f$add = false;
        $this$toColumn$iv$iv$iv = this_$iv$iv.getSource();
        createDataFrameDsl2 = this_$iv$iv;
        boolean $i$f$map62 = false;
        infer$iv$iv$iv = $this$map$iv$iv$iv;
        destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            it$iv$iv = item$iv$iv$iv$iv = iterator2.next();
            collection = destination$iv$iv$iv$iv;
            bl = false;
            collection.add(expression$iv$iv.invoke(it$iv$iv));
        }
        $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
        String $i$f$map62 = name$iv$iv;
        infer$iv$iv$iv = Infer.Nulls;
        $i$f$toColumn2 = false;
        CreateDataFrameDsl.add$default(createDataFrameDsl2, DataColumnInternalKt.forceResolve(infer$iv$iv$iv == Infer.Type ? DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), null, null, 12, null) : DataColumn.Companion.createByType((String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), Reflection.typeOf(Integer.TYPE), (Infer)((Object)infer$iv$iv$iv))), null, 2, null);
        this_$iv = $this$toDataFrame;
        $this$from$iv = (KProperty)describeImpl.df.1.13.INSTANCE;
        expression$iv = $this$toDataFrame;
        Function1 expression$iv2 = DescribeKt::describeImpl$lambda$3$6;
        boolean $i$f$inferType22 = false;
        CreateDataFrameDsl.InferType this_$iv2 = new CreateDataFrameDsl.InferType(expression$iv2);
        $i$f$from = false;
        Iterable $i$f$inferType22 = this_$iv.getSource();
        name$iv$iv = UtilsKt.getColumnName($this$from$iv);
        expression$iv$iv = DataColumn.Companion;
        CreateDataFrameDsl $i$f$add2 = this_$iv;
        boolean $i$f$map7 = false;
        createDataFrameDsl2 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv$iv), (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator $i$f$toColumn2 = $this$mapTo$iv$iv$iv.iterator();
        while ($i$f$toColumn2.hasNext()) {
            Object item$iv$iv$iv = $i$f$toColumn2.next();
            iterator2 = item$iv$iv$iv;
            item$iv$iv$iv$iv = destination$iv$iv$iv;
            boolean bl2 = false;
            item$iv$iv$iv$iv.add((Object)((CreateDataFrameDsl.InferType)((Object)inferType$iv)).getExpression().invoke((Object)it$iv));
        }
        item$iv$iv$iv$iv = (List)destination$iv$iv$iv;
        CreateDataFrameDsl.add$default($i$f$add2, DataColumn.Companion.createByInference$default((DataColumn.Companion)expression$iv$iv, name$iv$iv, item$iv$iv$iv$iv, null, null, 12, null), null, 2, null);
        if ($hasNumericCols) {
            this_$iv = $this$toDataFrame;
            $this$from$iv = (KProperty)describeImpl.df.1.15.INSTANCE;
            expression$iv = DescribeKt::describeImpl$lambda$3$7;
            $i$f$from = false;
            $this$map$iv$iv = this_$iv;
            name$iv$iv = UtilsKt.getColumnName($this$from$iv);
            expression$iv$iv = expression$iv;
            $i$f$add = false;
            Iterable $i$f$map7 = this_$iv$iv.getSource();
            $this$mapTo$iv$iv$iv = this_$iv$iv;
            boolean $i$f$map722 = false;
            void $i$f$mapTo22 = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
            $i$f$mapTo = false;
            it$iv = $this$mapTo$iv$iv$iv$iv.iterator();
            while (it$iv.hasNext()) {
                void it$iv$iv2;
                Object bl2 = item$iv$iv$iv$iv = it$iv.next();
                collection = destination$iv$iv$iv$iv;
                bl = false;
                collection.add(expression$iv$iv.invoke((Object)it$iv$iv2));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            String $i$f$map722 = name$iv$iv;
            infer$iv$iv$iv = Infer.Nulls;
            $i$f$toColumn = false;
            CreateDataFrameDsl.add$default($this$mapTo$iv$iv$iv, DataColumnInternalKt.forceResolve(infer$iv$iv$iv == Infer.Type ? DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), null, null, 12, null) : DataColumn.Companion.createByType((String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), Reflection.nullableTypeOf(Double.class), (Infer)((Object)infer$iv$iv$iv))), null, 2, null);
            this_$iv = $this$toDataFrame;
            $this$from$iv = (KProperty)describeImpl.df.1.17.INSTANCE;
            expression$iv = DescribeKt::describeImpl$lambda$3$8;
            $i$f$from = false;
            this_$iv$iv = this_$iv;
            name$iv$iv = UtilsKt.getColumnName($this$from$iv);
            expression$iv$iv = expression$iv;
            $i$f$add = false;
            $this$toColumn$iv$iv$iv = this_$iv$iv.getSource();
            $this$mapTo$iv$iv$iv = this_$iv$iv;
            boolean $i$f$map8 = false;
            infer$iv$iv$iv = $this$map$iv$iv$iv;
            destination$iv$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv$iv, (int)10));
            $i$f$mapTo = false;
            it$iv = $this$mapTo$iv$iv$iv$iv.iterator();
            while (it$iv.hasNext()) {
                Object it$iv$iv2 = item$iv$iv$iv$iv = it$iv.next();
                collection = destination$iv$iv$iv$iv;
                bl = false;
                collection.add(expression$iv$iv.invoke(it$iv$iv2));
            }
            $this$map$iv$iv$iv = (List)destination$iv$iv$iv$iv;
            $i$f$map62 = name$iv$iv;
            infer$iv$iv$iv = Infer.Nulls;
            $i$f$toColumn = false;
            CreateDataFrameDsl.add$default($this$mapTo$iv$iv$iv, DataColumnInternalKt.forceResolve(infer$iv$iv$iv == Infer.Type ? DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), null, null, 12, null) : DataColumn.Companion.createByType((String)name$iv$iv$iv, UtilsKt.asList($this$toColumn$iv$iv$iv), Reflection.nullableTypeOf(Double.class), (Infer)((Object)infer$iv$iv$iv))), null, 2, null);
        }
        if ($hasComparableCols || $hasNumericCols) {
            Collection<Object> collection2;
            this_$iv = $this$toDataFrame;
            $this$from$iv = (KProperty)describeImpl.df.1.19.INSTANCE;
            expression$iv = $this$toDataFrame;
            expression$iv = DescribeKt::describeImpl$lambda$3$9;
            boolean $i$f$inferType32 = false;
            this_$iv2 = new CreateDataFrameDsl.InferType(expression$iv);
            $i$f$from = false;
            Iterable $i$f$inferType32 = this_$iv.getSource();
            string = UtilsKt.getColumnName($this$from$iv);
            DataColumn.Companion companion = DataColumn.Companion;
            CreateDataFrameDsl createDataFrameDsl3 = this_$iv;
            boolean $i$f$map9 = false;
            $this$mapTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            Iterator iterator3 = $this$mapTo$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object item$iv$iv$iv = iterator3.next();
                it$iv = item$iv$iv$iv;
                collection2 = destination$iv$iv$iv;
                boolean bl3 = false;
                collection2.add(((CreateDataFrameDsl.InferType)((Object)inferType$iv)).getExpression().invoke(it$iv));
            }
            collection2 = (List)destination$iv$iv$iv;
            CreateDataFrameDsl.add$default(createDataFrameDsl3, DataColumn.Companion.createByInference$default(companion, string, (List)collection2, null, null, 12, null), null, 2, null);
            this_$iv = $this$toDataFrame;
            $this$from$iv = (KProperty)describeImpl.df.1.21.INSTANCE;
            inferType$iv = $this$toDataFrame;
            expression$iv = DescribeKt::describeImpl$lambda$3$10;
            boolean $i$f$inferType42 = false;
            this_$iv2 = new CreateDataFrameDsl.InferType(expression$iv);
            $i$f$from = false;
            Iterable $i$f$inferType42 = this_$iv.getSource();
            string = UtilsKt.getColumnName($this$from$iv);
            companion = DataColumn.Companion;
            createDataFrameDsl3 = this_$iv;
            $i$f$map9 = false;
            $this$mapTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            $i$f$mapTo3 = false;
            iterator3 = $this$mapTo$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object item$iv$iv$iv = iterator3.next();
                it$iv = item$iv$iv$iv;
                collection2 = destination$iv$iv$iv;
                boolean bl4 = false;
                collection2.add(((CreateDataFrameDsl.InferType)((Object)inferType$iv)).getExpression().invoke(it$iv));
            }
            collection2 = (List)destination$iv$iv$iv;
            CreateDataFrameDsl.add$default(createDataFrameDsl3, DataColumn.Companion.createByInference$default(companion, string, collection2, null, null, 12, null), null, 2, null);
            this_$iv = $this$toDataFrame;
            $this$from$iv = (KProperty)describeImpl.df.1.23.INSTANCE;
            inferType$iv = $this$toDataFrame;
            expression$iv = DescribeKt::describeImpl$lambda$3$11;
            boolean $i$f$inferType52 = false;
            this_$iv2 = new CreateDataFrameDsl.InferType(expression$iv);
            $i$f$from = false;
            Iterable $i$f$inferType52 = this_$iv.getSource();
            string = UtilsKt.getColumnName($this$from$iv);
            companion = DataColumn.Companion;
            createDataFrameDsl3 = this_$iv;
            $i$f$map9 = false;
            $this$mapTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            $i$f$mapTo3 = false;
            iterator3 = $this$mapTo$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object item$iv$iv$iv = iterator3.next();
                it$iv = item$iv$iv$iv;
                collection2 = destination$iv$iv$iv;
                boolean bl5 = false;
                collection2.add(((CreateDataFrameDsl.InferType)((Object)inferType$iv)).getExpression().invoke(it$iv));
            }
            collection2 = (List)destination$iv$iv$iv;
            CreateDataFrameDsl.add$default(createDataFrameDsl3, DataColumn.Companion.createByInference$default(companion, string, collection2, null, null, 12, null), null, 2, null);
            this_$iv = $this$toDataFrame;
            $this$from$iv = (KProperty)describeImpl.df.1.25.INSTANCE;
            inferType$iv = $this$toDataFrame;
            expression$iv = DescribeKt::describeImpl$lambda$3$12;
            boolean $i$f$inferType62 = false;
            this_$iv2 = new CreateDataFrameDsl.InferType(expression$iv);
            $i$f$from = false;
            Iterable $i$f$inferType62 = this_$iv.getSource();
            string = UtilsKt.getColumnName($this$from$iv);
            companion = DataColumn.Companion;
            createDataFrameDsl3 = this_$iv;
            $i$f$map9 = false;
            $this$mapTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            $i$f$mapTo3 = false;
            iterator3 = $this$mapTo$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object item$iv$iv$iv = iterator3.next();
                it$iv = item$iv$iv$iv;
                collection2 = destination$iv$iv$iv;
                boolean bl6 = false;
                collection2.add(((CreateDataFrameDsl.InferType)((Object)inferType$iv)).getExpression().invoke(it$iv));
            }
            collection2 = (List)destination$iv$iv$iv;
            CreateDataFrameDsl.add$default(createDataFrameDsl3, DataColumn.Companion.createByInference$default(companion, string, collection2, null, null, 12, null), null, 2, null);
            this_$iv = $this$toDataFrame;
            $this$from$iv = (KProperty)describeImpl.df.1.27.INSTANCE;
            inferType$iv = $this$toDataFrame;
            expression$iv = DescribeKt::describeImpl$lambda$3$13;
            boolean $i$f$inferType72 = false;
            this_$iv2 = new CreateDataFrameDsl.InferType(expression$iv);
            $i$f$from = false;
            Iterable $i$f$inferType72 = this_$iv.getSource();
            string = UtilsKt.getColumnName($this$from$iv);
            companion = DataColumn.Companion;
            createDataFrameDsl3 = this_$iv;
            $i$f$map9 = false;
            $this$mapTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            $i$f$mapTo3 = false;
            iterator3 = $this$mapTo$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object item$iv$iv$iv = iterator3.next();
                it$iv = item$iv$iv$iv;
                collection2 = destination$iv$iv$iv;
                boolean bl7 = false;
                collection2.add(((CreateDataFrameDsl.InferType)((Object)inferType$iv)).getExpression().invoke(it$iv));
            }
            collection2 = (List)destination$iv$iv$iv;
            CreateDataFrameDsl.add$default(createDataFrameDsl3, DataColumn.Companion.createByInference$default(companion, string, collection2, null, null, 12, null), null, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final String describeImpl$lambda$3$0(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.name();
    }

    private static final ColumnPath describeImpl$lambda$3$1(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.path();
    }

    private static final String describeImpl$lambda$3$2(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RenderingKt.renderType(DataColumnKt.getType(it));
    }

    private static final int describeImpl$lambda$3$3(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BaseColumnKt.getSize(it);
    }

    private static final int describeImpl$lambda$3$4(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.countDistinct();
    }

    /*
     * WARNING - void declaration
     */
    private static final int describeImpl$lambda$3$5(DataColumn it) {
        int n;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$count$iv = BaseColumnKt.getValues(it);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            Iterator iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it2 = element$iv = iterator2.next();
                boolean bl = false;
                if (!(it2 == null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object describeImpl$lambda$3$6(DataColumn it) {
        Object v1;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$groupBy$iv = CollectionsKt.filterNotNull(BaseColumnKt.getValues(it));
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator3 = $this$groupByTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Object element$iv$iv;
            Object it2 = element$iv$iv = iterator3.next();
            boolean bl = false;
            Object key$iv$iv = it2;
            Map map2 = destination$iv$iv;
            Object key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable iterable = destination$iv$iv.entrySet();
        iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v1 = null;
        } else {
            Object e = iterator2.next();
            if (!iterator2.hasNext()) {
                v1 = e;
            } else {
                Map.Entry it3 = (Map.Entry)e;
                boolean bl = false;
                int n = ((List)it3.getValue()).size();
                do {
                    Object e2 = iterator2.next();
                    Map.Entry it4 = (Map.Entry)e2;
                    $i$a$-maxByOrNull-DescribeKt$describeImpl$df$1$14$2 = false;
                    int n2 = ((List)it4.getValue()).size();
                    if (n >= n2) continue;
                    e = e2;
                    n = n2;
                } while (iterator2.hasNext());
                v1 = e;
            }
        }
        Map.Entry entry = v1;
        return entry != null ? entry.getKey() : null;
    }

    private static final Double describeImpl$lambda$3$7(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DataColumnTypeKt.isNumber(it) ? Double.valueOf(MeanKt.mean$default(TypeConversionsKt.asNumberAnyNullable(it), false, 1, null)) : null;
    }

    private static final Double describeImpl$lambda$3$8(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DataColumnTypeKt.isNumber(it) ? Double.valueOf(StdKt.std$default(TypeConversionsKt.asNumberAnyNullable(it), false, 0, 3, null)) : null;
    }

    private static final Object describeImpl$lambda$3$9(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataColumn<Comparable<Object>> dataColumn = DescribeKt.convertToComparableOrNull(it);
        return dataColumn != null ? MinKt.minOrNull$default(dataColumn, false, 1, null) : null;
    }

    private static final Object describeImpl$lambda$3$10(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataColumn<Comparable<Object>> dataColumn = DescribeKt.convertToComparableOrNull(it);
        return dataColumn != null ? PercentileKt.percentileOrNull(dataColumn, 25.0) : null;
    }

    private static final Object describeImpl$lambda$3$11(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataColumn<Comparable<Object>> dataColumn = DescribeKt.convertToComparableOrNull(it);
        return dataColumn != null ? MedianKt.medianOrNull(dataColumn) : null;
    }

    private static final Object describeImpl$lambda$3$12(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataColumn<Comparable<Object>> dataColumn = DescribeKt.convertToComparableOrNull(it);
        return dataColumn != null ? PercentileKt.percentileOrNull(dataColumn, 75.0) : null;
    }

    private static final Object describeImpl$lambda$3$13(DataColumn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataColumn<Comparable<Object>> dataColumn = DescribeKt.convertToComparableOrNull(it);
        return dataColumn != null ? MaxKt.maxOrNull$default(dataColumn, false, 1, null) : null;
    }

    private static final int describeImpl$lambda$4(List $allCols, AddDataRow $this$add, AddDataRow it) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object top2 = it.get((KProperty)describeImpl.2.top.1.INSTANCE);
        DataColumn data = (DataColumn)$allCols.get(DataRowKt.getIndex($this$add));
        Iterable $this$count$iv = BaseColumnKt.getValues(data);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it2 = element$iv = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(it2, top2) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColumnKind.values().length];
            try {
                nArray[ColumnKind.Frame.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnKind.Group.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnKind.Value.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

