/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\f\u0010\b\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\t\u001a\u00020\n\u001a3\u0010\u000e\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00040\u0014H\u0082\b\u001a\u001e\u0010\u0016\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\u0019\u001a\n \u0002*\u0004\u0018\u00010\u00060\u0006*\u00020\nH\u0002\u001a&\u0010\u001a\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0012\u001a&\u0010\u001a\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\u0012\u001a)\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u001e0\u0014\u00a2\u0006\u0002\u0010 \u001a1\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\n2\u0006\u0010!\u001a\u00020\u00122\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u001e0\u0014\u00a2\u0006\u0002\u0010\"\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\n2\u0006\u0010#\u001a\u00020\n\u001a\u0016\u0010$\u001a\u00020\u000b*\u00020\n2\b\b\u0002\u0010!\u001a\u00020\u0012H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"DEFAULT_ZIP_ENTRY_TIME", "Ljava/nio/file/attribute/FileTime;", "kotlin.jvm.PlatformType", "zipDirAs", "", "dirPath", "Ljava/nio/file/Path;", "zipFilePath", "expandSymlinks", "file", "Lorg/jetbrains/kotlin/konan/file/File;", "Ljava/nio/file/FileSystem;", "path", "", "newEntry", "Ljava/util/zip/ZipOutputStream;", "relativePath", "isDir", "", "block", "Lkotlin/Function1;", "Ljava/util/zip/ZipEntry;", "recursiveCopyTo", "destination", "resetTimeAttributes", "toPath", "unzipTo", "destinationDirectory", "fromSubdirectory", "withZipFileSystem", "T", "action", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "create", "(Lorg/jetbrains/kotlin/konan/file/File;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "zipFile", "zipFileSystem", "kotlin-util-io"})
@SourceDebugExtension(value={"SMAP\nZipUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n*L\n1#1,191:1\n774#2:192\n865#2,2:193\n1611#2,9:195\n1863#2:204\n1864#2:206\n1620#2:207\n1#3:205\n214#4,3:208\n214#4,13:211\n225#4,2:224\n217#4,7:226\n214#4,13:233\n*S KotlinDebug\n*F\n+ 1 ZipUtil.kt\norg/jetbrains/kotlin/konan/file/ZipUtilKt\n*L\n31#1:192\n31#1:193,2\n31#1:195,9\n31#1:204\n31#1:206\n31#1:207\n31#1:205\n55#1:208,3\n56#1:211,13\n55#1:224,2\n55#1:226,7\n155#1:233,13\n*E\n"})
public final class ZipUtilKt {
    private static final FileTime DEFAULT_ZIP_ENTRY_TIME = FileTime.fromMillis(0L);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FileSystem zipFileSystem(@NotNull File $this$zipFileSystem, boolean create2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$zipFileSystem, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"create", (Object)String.valueOf(create2))};
        HashMap attributes = MapsKt.hashMapOf((Pair[])pairArray);
        List<FileSystemProvider> list = FileSystemProvider.installedProviders();
        Intrinsics.checkNotNullExpressionValue(list, (String)"installedProviders()");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileSystemProvider it = (FileSystemProvider)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getScheme(), (Object)"jar")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FileSystem it$iv$iv;
            FileSystem fileSystem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FileSystemProvider it = (FileSystemProvider)element$iv$iv;
            boolean bl2 = false;
            try {
                fileSystem = it.newFileSystem(ZipUtilKt.toPath($this$zipFileSystem), (Map)attributes);
            }
            catch (Exception e) {
                Exception exception = e;
                if (!(exception instanceof UnsupportedOperationException ? true : exception instanceof IllegalArgumentException)) {
                    throw e;
                }
                fileSystem = null;
            }
            if (fileSystem == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (FileSystem)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    public static /* synthetic */ FileSystem zipFileSystem$default(File file, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ZipUtilKt.zipFileSystem(file, bl);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = $this$file.getPath(file.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.getPath(file.path)");
        return new File(path);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$file, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = $this$file.getPath(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.getPath(path)");
        return new File(path2);
    }

    private static final Path toPath(File $this$toPath) {
        return Paths.get($this$toPath.getPath(), new String[0]);
    }

    public static final void zipDirAs(@NotNull File $this$zipDirAs, @NotNull File zipFile) {
        Intrinsics.checkNotNullParameter((Object)$this$zipDirAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        ZipUtilKt.zipDirAs($this$zipDirAs.getJavaPath$kotlin_util_io(), zipFile.getJavaPath$kotlin_util_io());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void zipDirAs(Path dirPath, Path zipFilePath) {
        Path dirPathWithExpandedSymlinks = ZipUtilKt.expandSymlinks(dirPath);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(zipFilePath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        AutoCloseable $this$use$iv = outputStream;
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            OutputStream outputStream2 = (OutputStream)$this$use$iv;
            boolean bl = false;
            AutoCloseable $this$use$iv2 = new ZipOutputStream(outputStream2);
            boolean $i$f$use2 = false;
            boolean closed$iv2 = false;
            try {
                ZipOutputStream zipOutputStream = (ZipOutputStream)$this$use$iv2;
                boolean bl2 = false;
                zipOutputStream.setLevel(5);
                Files.walk(dirPathWithExpandedSymlinks, new FileVisitOption[0]).forEach(new Consumer(dirPathWithExpandedSymlinks, dirPath, zipOutputStream){
                    final /* synthetic */ Path $dirPathWithExpandedSymlinks;
                    final /* synthetic */ Path $dirPath;
                    final /* synthetic */ ZipOutputStream $zipOutputStream;
                    {
                        this.$dirPathWithExpandedSymlinks = $dirPathWithExpandedSymlinks;
                        this.$dirPath = $dirPath;
                        this.$zipOutputStream = $zipOutputStream;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void accept(Path path) {
                        ZipOutputStream $this$newEntry$iv;
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        Path pathWithExpandedSymlinks = ZipUtilKt.access$expandSymlinks(path);
                        if (!pathWithExpandedSymlinks.startsWith(this.$dirPathWithExpandedSymlinks)) {
                            throw new ZipException("An attempt to escape the source directory " + this.$dirPath + " in symlink " + path);
                        }
                        if (Intrinsics.areEqual((Object)pathWithExpandedSymlinks, (Object)this.$dirPathWithExpandedSymlinks)) {
                            return;
                        }
                        String relativePath = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)path, (Path)this.$dirPathWithExpandedSymlinks));
                        Object object = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                        BasicFileAttributes attributes = Files.readAttributes(pathWithExpandedSymlinks, BasicFileAttributes.class, object);
                        if (attributes.isRegularFile()) {
                            ZipEntry zipEntry;
                            object = this.$zipOutputStream;
                            boolean bl = false;
                            ZipOutputStream zipOutputStream = this.$zipOutputStream;
                            boolean $i$f$newEntry = false;
                            ZipEntry it$iv = zipEntry = new ZipEntry(relativePath);
                            boolean bl2 = false;
                            it$iv.setMethod(8);
                            ZipEntry entry$iv = zipEntry;
                            entry$iv.setCreationTime(ZipUtilKt.access$getDEFAULT_ZIP_ENTRY_TIME$p());
                            entry$iv.setLastModifiedTime(ZipUtilKt.access$getDEFAULT_ZIP_ENTRY_TIME$p());
                            entry$iv.setLastAccessTime(ZipUtilKt.access$getDEFAULT_ZIP_ENTRY_TIME$p());
                            entry$iv.setExtra(null);
                            $this$newEntry$iv.putNextEntry(entry$iv);
                            ZipEntry it = entry$iv;
                            boolean bl3 = false;
                            Files.copy(pathWithExpandedSymlinks, zipOutputStream);
                            $this$newEntry$iv.closeEntry();
                        } else if (attributes.isDirectory()) {
                            void $this$newEntry_u24default$iv;
                            ZipEntry zipEntry;
                            $this$newEntry$iv = this.$zipOutputStream;
                            boolean isDir$iv = true;
                            boolean $i$f$newEntry = false;
                            ZipEntry it$iv = zipEntry = new ZipEntry(relativePath + '/');
                            boolean bl = false;
                            it$iv.setMethod(0);
                            it$iv.setSize(0L);
                            it$iv.setCrc(0L);
                            ZipEntry entry$iv = zipEntry;
                            entry$iv.setCreationTime(ZipUtilKt.access$getDEFAULT_ZIP_ENTRY_TIME$p());
                            entry$iv.setLastModifiedTime(ZipUtilKt.access$getDEFAULT_ZIP_ENTRY_TIME$p());
                            entry$iv.setLastAccessTime(ZipUtilKt.access$getDEFAULT_ZIP_ENTRY_TIME$p());
                            entry$iv.setExtra(null);
                            $this$newEntry_u24default$iv.putNextEntry(entry$iv);
                            ZipEntry it = entry$iv;
                            boolean bl4 = false;
                            $this$newEntry_u24default$iv.closeEntry();
                        } else {
                            throw new IllegalStateException(("Unsupported file type encountered: " + path).toString());
                        }
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv2 = true;
                    try {
                        $this$use$iv2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv2) {
                        $this$use$iv2.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv2.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
    }

    private static final void newEntry(ZipOutputStream $this$newEntry, String relativePath, boolean isDir, Function1<? super ZipEntry, Unit> block) {
        ZipEntry zipEntry;
        ZipEntry it;
        ZipEntry zipEntry2;
        boolean $i$f$newEntry = false;
        if (isDir) {
            it = zipEntry2 = new ZipEntry(relativePath + '/');
            boolean bl = false;
            it.setMethod(0);
            it.setSize(0L);
            it.setCrc(0L);
            zipEntry = zipEntry2;
        } else {
            it = zipEntry2 = new ZipEntry(relativePath);
            boolean bl = false;
            it.setMethod(8);
            zipEntry = zipEntry2;
        }
        ZipEntry entry = zipEntry;
        entry.setCreationTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
        entry.setLastModifiedTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
        entry.setLastAccessTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
        entry.setExtra(null);
        $this$newEntry.putNextEntry(entry);
        block.invoke((Object)entry);
        $this$newEntry.closeEntry();
    }

    static /* synthetic */ void newEntry$default(ZipOutputStream $this$newEntry_u24default, String relativePath, boolean isDir, Function1 block, int n, Object object) {
        ZipEntry zipEntry;
        ZipEntry it;
        ZipEntry zipEntry2;
        if ((n & 4) != 0) {
            block = newEntry.1.INSTANCE;
        }
        boolean $i$f$newEntry = false;
        if (isDir) {
            it = zipEntry2 = new ZipEntry(relativePath + '/');
            boolean bl = false;
            it.setMethod(0);
            it.setSize(0L);
            it.setCrc(0L);
            zipEntry = zipEntry2;
        } else {
            it = zipEntry2 = new ZipEntry(relativePath);
            boolean bl = false;
            it.setMethod(8);
            zipEntry = zipEntry2;
        }
        ZipEntry entry = zipEntry;
        entry.setCreationTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
        entry.setLastModifiedTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
        entry.setLastAccessTime(ZipUtilKt.DEFAULT_ZIP_ENTRY_TIME);
        entry.setExtra(null);
        $this$newEntry_u24default.putNextEntry(entry);
        block.invoke((Object)entry);
        $this$newEntry_u24default.closeEntry();
    }

    private static final Path expandSymlinks(Path $this$expandSymlinks) {
        Path path;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Windows", (boolean)false, (int)2, null)) {
            String rawPath = ((Object)$this$expandSymlinks).toString();
            Path path2 = StringsKt.startsWith$default((String)rawPath, (String)"/", (boolean)false, (int)2, null) ? Paths.get(StringsKt.removePrefix((String)rawPath, (CharSequence)"/"), new String[0]) : $this$expandSymlinks;
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n        val rawPath = \u2026se\n            this\n    }");
        } else {
            path = $this$expandSymlinks;
        }
        Path correctedPath = path;
        Path path3 = correctedPath.toRealPath(new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"correctedPath.toRealPath()");
        return path3;
    }

    public static final void unzipTo(@NotNull File $this$unzipTo, @NotNull File destinationDirectory, @NotNull File fromSubdirectory, boolean resetTimeAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$unzipTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)fromSubdirectory, (String)"fromSubdirectory");
        ZipUtilKt.withZipFileSystem($this$unzipTo, (Function1)new Function1<FileSystem, Unit>(fromSubdirectory, destinationDirectory, resetTimeAttributes){
            final /* synthetic */ File $fromSubdirectory;
            final /* synthetic */ File $destinationDirectory;
            final /* synthetic */ boolean $resetTimeAttributes;
            {
                this.$fromSubdirectory = $fromSubdirectory;
                this.$destinationDirectory = $destinationDirectory;
                this.$resetTimeAttributes = $resetTimeAttributes;
                super(1);
            }

            public final void invoke(FileSystem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ZipUtilKt.access$recursiveCopyTo(ZipUtilKt.file(it, this.$fromSubdirectory), this.$destinationDirectory, this.$resetTimeAttributes);
            }
        });
    }

    public static /* synthetic */ void unzipTo$default(File file, File file2, File file3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file3 = new File("/");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        ZipUtilKt.unzipTo(file, file2, file3, bl);
    }

    public static final void unzipTo(@NotNull Path $this$unzipTo, @NotNull Path destinationDirectory, @NotNull Path fromSubdirectory, boolean resetTimeAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$unzipTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)fromSubdirectory, (String)"fromSubdirectory");
        ZipUtilKt.unzipTo(new File($this$unzipTo), new File(destinationDirectory), new File(fromSubdirectory), resetTimeAttributes);
    }

    public static /* synthetic */ void unzipTo$default(Path path, Path path2, Path path3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            Path path4 = Paths.get("/", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(\"/\")");
            path3 = path4;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        ZipUtilKt.unzipTo(path, path2, path3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, boolean create2, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable $this$use$iv = ZipUtilKt.zipFileSystem($this$withZipFileSystem, create2);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            object = action.invoke((Object)$this$use$iv);
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return (T)object;
    }

    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$withZipFileSystem, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return ZipUtilKt.withZipFileSystem($this$withZipFileSystem, false, action);
    }

    private static final void recursiveCopyTo(File $this$recursiveCopyTo, File destination, boolean resetTimeAttributes) {
        Path sourcePath = $this$recursiveCopyTo.getJavaPath$kotlin_util_io();
        Path destPath = destination.getJavaPath$kotlin_util_io();
        FileSystem destFs = destPath.getFileSystem();
        Path normalizedDestPath = destPath.normalize();
        Files.walk(sourcePath, new FileVisitOption[0]).forEach(new Consumer(sourcePath, destFs, destPath, normalizedDestPath, destination, resetTimeAttributes){
            final /* synthetic */ Path $sourcePath;
            final /* synthetic */ FileSystem $destFs;
            final /* synthetic */ Path $destPath;
            final /* synthetic */ Path $normalizedDestPath;
            final /* synthetic */ File $destination;
            final /* synthetic */ boolean $resetTimeAttributes;
            {
                this.$sourcePath = $sourcePath;
                this.$destFs = $destFs;
                this.$destPath = $destPath;
                this.$normalizedDestPath = $normalizedDestPath;
                this.$destination = $destination;
                this.$resetTimeAttributes = $resetTimeAttributes;
            }

            public final void accept(Path oldPath) {
                Path relative = this.$sourcePath.relativize(oldPath);
                Object[] objectArray = new String[]{((Object)relative).toString()};
                Path newPath = this.$destFs.getPath(((Object)this.$destPath).toString(), (String[])objectArray);
                if (!newPath.normalize().startsWith(this.$normalizedDestPath)) {
                    throw new ZipException(relative + " attempted to escape the destination directory " + this.$destination);
                }
                if (Intrinsics.areEqual((Object)newPath, (Object)newPath.getRoot())) {
                    return;
                }
                if (Files.isDirectory(newPath, new LinkOption[0])) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(oldPath, newPath, (CopyOption[])objectArray);
                }
                if (this.$resetTimeAttributes) {
                    FileTime zero = FileTime.fromMillis(0L);
                    Files.getFileAttributeView(newPath, BasicFileAttributeView.class, new LinkOption[0]).setTimes(zero, zero, zero);
                }
            }
        });
    }

    static /* synthetic */ void recursiveCopyTo$default(File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        ZipUtilKt.recursiveCopyTo(file, file2, bl);
    }

    public static final /* synthetic */ void access$recursiveCopyTo(File $receiver, File destination, boolean resetTimeAttributes) {
        ZipUtilKt.recursiveCopyTo($receiver, destination, resetTimeAttributes);
    }

    public static final /* synthetic */ Path access$expandSymlinks(Path $receiver) {
        return ZipUtilKt.expandSymlinks($receiver);
    }
}

