/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.util.Objects;
import org.gradle.api.Project;
import org.jspecify.annotations.Nullable;

public interface ProjectDetails {
    public String getDisplayName();

    public @Nullable String getDescription();

    public String getRelativeProjectDir();

    public String getAbsoluteProjectDir();

    public static ProjectDetails of(Project project) {
        return ProjectDetails.withDisplayNameAndDescription(project);
    }

    public static ProjectNameAndPath withNameAndPath(Project project) {
        return new ProjectNameAndPath(project);
    }

    public static ProjectDisplayNameAndDescription withDisplayNameAndDescription(Project project) {
        return new ProjectDisplayNameAndDescription(project);
    }

    public static class ProjectDisplayNameAndDescription
    implements ProjectDetails {
        private final String displayName;
        private final @Nullable String description;
        private final String absoluteProjectDirPath;
        private final String relativeProjectDirPath;
        private final String projectLogicalPath;

        private ProjectDisplayNameAndDescription(Project project) {
            this.displayName = project.getDisplayName();
            this.description = project.getDescription();
            this.absoluteProjectDirPath = project.getProjectDir().toPath().toString();
            this.relativeProjectDirPath = project.getRootProject().getProjectDir().toPath().relativize(project.getProjectDir().toPath()).toString();
            this.projectLogicalPath = project.getBuildTreePath();
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public @Nullable String getDescription() {
            return this.description;
        }

        @Override
        public String getRelativeProjectDir() {
            return this.relativeProjectDirPath;
        }

        @Override
        public String getAbsoluteProjectDir() {
            return this.absoluteProjectDirPath;
        }

        public int hashCode() {
            return Objects.hash(this.displayName, this.description, this.relativeProjectDirPath, this.projectLogicalPath);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProjectDisplayNameAndDescription)) {
                return false;
            }
            ProjectDisplayNameAndDescription that = (ProjectDisplayNameAndDescription)obj;
            return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.relativeProjectDirPath, that.relativeProjectDirPath) && Objects.equals(this.projectLogicalPath, that.projectLogicalPath);
        }
    }

    public static class ProjectNameAndPath
    extends ProjectDisplayNameAndDescription {
        private final String name;
        private final String path;

        private ProjectNameAndPath(Project project) {
            super(project);
            this.name = project.getName();
            this.path = project.getPath();
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.path, super.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof ProjectNameAndPath)) {
                return false;
            }
            ProjectNameAndPath that = (ProjectNameAndPath)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.path, that.path);
        }
    }
}

