/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type DOMNode } from './dom.js';
export declare const comparePoints: (nodeA: DOMNode, offsetA: number, nodeB: DOMNode, offsetB: number) => number;
export declare class Range {
    startContainer: DOMNode | undefined;
    startOffset: number;
    endContainer: DOMNode | undefined;
    endOffset: number;
    collapsed: boolean;
    commonAncestorContainer: DOMNode | undefined;
    setStart(node: DOMNode, offset: number): void;
    setEnd(node: DOMNode, offset: number): void;
    collapse(toStart: boolean): void;
    selectNode(node: DOMNode): void;
    selectNodeContents(node: DOMNode): void;
    toString(): string;
    private updateCollapsed;
    private updateCommonAncestor;
    private getPath;
}
export declare class Selection {
    anchorNode: DOMNode | undefined;
    anchorOffset: number;
    focusNode: DOMNode | undefined;
    focusOffset: number;
    isCollapsed: boolean;
    rangeCount: number;
    private ranges;
    private readonly listeners;
    onChange(listener: () => void): () => void;
    toString(): string;
    getRangeAt(index: number): Range;
    addRange(range: Range): void;
    removeRange(range: Range): void;
    removeAllRanges(): void;
    collapse(node: DOMNode, offset: number): void;
    containsNode(node: DOMNode, allowPartialContainment?: boolean): boolean;
    private clearState;
    private notifyChange;
}
