/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.ColorProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class NodeColorControlGroup
implements ControlGroup {
    static final String NODE_COLOR = "nodecolor";
    private static final String NODE_TEXT_COLOR = "standardnodetextcolor";
    private RevertingProperty mSetNodeColor;
    private ColorProperty mNodeColor;
    private NodeColorChangeListener propertyChangeListener;

    NodeColorControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeColor = new RevertingProperty();
        this.mNodeColor = new ColorProperty(NODE_COLOR, ResourceController.getResourceController().getDefaultProperty(NODE_TEXT_COLOR));
        this.propertyChangeListener = new NodeColorChangeListener(this.mSetNodeColor, (IPropertyControl)this.mNodeColor);
        this.mSetNodeColor.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeColor.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeColor.appendToForm(formBuilder);
        this.mSetNodeColor.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class NodeColorChangeListener
    extends ControlGroupChangeListener {
        public NodeColorChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setColor(node, enabled ? NodeColorControlGroup.this.mNodeColor.getColorValue() : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            Color nodeColor = NodeStyleModel.getColor((NodeModel)node);
            Color viewNodeColor = styleController.getColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            NodeColorControlGroup.this.mSetNodeColor.setValue(nodeColor != null);
            NodeColorControlGroup.this.mNodeColor.setColorValue(viewNodeColor);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, NodeColorControlGroup.this.mSetNodeColor);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeColorControlGroup.this.mNodeColor);
        }
    }
}

