/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.collection;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;

public class OptionalReference<T> {
    private final WeakReference<T> reference;

    public OptionalReference(T content) {
        this.reference = new WeakReference<T>(content);
    }

    public T get() {
        Object object = this.reference.get();
        if (object != null && !this.reference.isEnqueued()) {
            return object;
        }
        return null;
    }

    public void ifPresent(Consumer<T> consumer) {
        T object = this.get();
        if (object != null) {
            consumer.accept(object);
        }
    }

    public boolean isPresent() {
        return this.reference.get() != null && !this.reference.isEnqueued();
    }
}

