/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.hover.hoverable;

import java.awt.AWTEvent;
import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.hover.hoverable.Hoverable;
import net.infonode.util.ArrayUtil;

public class HoverManager {
    private static HoverManager INSTANCE = new HoverManager();
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(final HierarchyEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        if (((Component)e.getSource()).isShowing()) {
                            HoverManager.this.addHoverListeners((Hoverable)e.getSource());
                        } else {
                            HoverManager.this.removeHoverListeners((Hoverable)e.getSource());
                        }
                    }
                }
            });
        }
    };
    private final MouseInputAdapter mouseAdapter = new MouseInputAdapter(){};
    private final HashSet hoverableComponents = new HashSet();
    private final ArrayList enteredComponents = new ArrayList();
    private boolean enabled = true;
    private boolean hasPermission = true;
    private boolean active = true;
    private boolean gotEnterAfterExit = false;
    private boolean isDrag = false;
    private final AWTEventListener eventListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent e) {
            if (HoverManager.this.active) {
                HoverManager.this.eventDispatched(e);
            }
        }
    };

    private void eventDispatched(AWTEvent e) {
        if (e.getSource() instanceof Component && e instanceof MouseEvent) {
            MouseEvent event = (MouseEvent)e;
            if (event.getID() == 501 || event.getID() == 502) {
                this.handleButtonEvent(event);
            } else if (event.getID() == 504 || event.getID() == 503) {
                this.handleEnterEvent(event);
            } else if (event.getID() == 505) {
                this.handleExitEvent(event);
            } else if (event.getID() == 506) {
                this.isDrag = true;
            }
        }
    }

    private void handleButtonEvent(MouseEvent event) {
        if (event.getID() == 501 && event.getButton() == 1) {
            this.enabled = false;
            this.isDrag = false;
        } else if (!this.enabled && event.getID() == 502) {
            this.enabled = true;
            if (this.isDrag) {
                final Component top = ComponentUtil.getTopLevelAncestor((Component)event.getSource());
                if (top == null) {
                    this.exitAll();
                } else if (!((Component)event.getSource()).contains(event.getPoint())) {
                    final Point p = SwingUtilities.convertPoint((Component)event.getSource(), event.getPoint(), top);
                    if (!top.contains(p.x, p.y)) {
                        this.exitAll();
                    } else if (top instanceof Container) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Component c = ComponentUtil.findComponentUnderGlassPaneAt(p, top);
                                        if (c != null) {
                                            Point p2 = SwingUtilities.convertPoint(top, p, c);
                                            HoverManager.this.eventDispatched(new MouseEvent(c, 504, 0L, 0, p2.x, p2.y, 0, false));
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
            }
        }
    }

    private void handleEnterEvent(MouseEvent event) {
        this.gotEnterAfterExit = true;
        ArrayList<Object> exitables = new ArrayList<Object>(this.enteredComponents);
        ArrayList<Component> enterables = new ArrayList<Component>();
        Component c = (Component)event.getSource();
        while (c != null) {
            if (this.hoverableComponents.contains(c)) {
                exitables.remove(c);
                enterables.add(c);
            }
            c = c.getParent();
        }
        if (enterables.size() > 0) {
            Object[] obj = enterables.toArray();
            int i = obj.length - 1;
            while (i >= 0) {
                if (!((Hoverable)obj[i]).acceptHover(enterables)) {
                    enterables.remove(obj[i]);
                    exitables.add(obj[i]);
                }
                --i;
            }
        }
        int i = exitables.size() - 1;
        while (i >= 0) {
            this.dispatchExit((Hoverable)exitables.get(i));
            --i;
        }
        i = enterables.size() - 1;
        while (i >= 0) {
            this.dispatchEnter((Hoverable)enterables.get(i));
            --i;
        }
    }

    private void handleExitEvent(MouseEvent event) {
        this.gotEnterAfterExit = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!HoverManager.this.gotEnterAfterExit) {
                    HoverManager.this.exitAll();
                }
            }
        });
    }

    public static HoverManager getInstance() {
        return INSTANCE;
    }

    private HoverManager() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new AWTPermission("listenToAllAWTEvents"));
            }
        }
        catch (SecurityException e) {
            this.hasPermission = false;
        }
    }

    private void exitAll() {
        this.gotEnterAfterExit = false;
        Object[] obj = this.enteredComponents.toArray();
        int i = obj.length - 1;
        while (i >= 0) {
            this.dispatchExit((Hoverable)obj[i]);
            --i;
        }
    }

    public void init() {
        this.gotEnterAfterExit = false;
        this.isDrag = false;
        this.enabled = true;
    }

    public void setEventListeningActive(boolean active) {
        this.active = active;
    }

    public void dispatchEvent(MouseEvent event) {
        this.eventDispatched(event);
    }

    private void addHoverListeners(Hoverable hoverable) {
        if (this.hoverableComponents.add(hoverable)) {
            Component c = (Component)((Object)hoverable);
            c.addMouseListener(this.mouseAdapter);
            c.addMouseMotionListener(this.mouseAdapter);
            if (this.active && this.hoverableComponents.size() == 1) {
                try {
                    Toolkit.getDefaultToolkit().addAWTEventListener(this.eventListener, 48L);
                    this.hasPermission = true;
                }
                catch (SecurityException e) {
                    this.hasPermission = false;
                }
            }
        }
    }

    private void removeHoverListeners(Hoverable hoverable) {
        if (this.hoverableComponents.remove(hoverable)) {
            ((Component)((Object)hoverable)).removeMouseListener(this.mouseAdapter);
            ((Component)((Object)hoverable)).removeMouseMotionListener(this.mouseAdapter);
            this.dispatchExit(hoverable);
            if (this.hasPermission && this.hoverableComponents.size() == 0) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.eventListener);
            }
        }
    }

    public void addHoverable(Hoverable hoverable) {
        if (hoverable instanceof Component) {
            Component c = (Component)((Object)hoverable);
            if (ArrayUtil.contains(c.getHierarchyListeners(), this.hierarchyListener)) {
                return;
            }
            c.addHierarchyListener(this.hierarchyListener);
            if (c.isShowing()) {
                this.addHoverListeners(hoverable);
            }
        }
    }

    public void removeHoverable(Hoverable hoverable) {
        Component c = (Component)((Object)hoverable);
        c.removeHierarchyListener(this.hierarchyListener);
        this.removeHoverListeners(hoverable);
    }

    public boolean isHovered(Hoverable c) {
        return this.enteredComponents.contains(c);
    }

    public boolean isEventListeningActive() {
        return this.active && this.hasPermission;
    }

    private void dispatchEnter(Hoverable hoverable) {
        if (this.enabled && !this.enteredComponents.contains(hoverable)) {
            this.enteredComponents.add(hoverable);
            hoverable.hoverEnter();
        }
    }

    private void dispatchExit(Hoverable hoverable) {
        if (this.enabled && this.enteredComponents.remove(hoverable)) {
            hoverable.hoverExit();
        }
    }
}

