/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.dialogs.about;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.ui.internal.dialogs.about.HyperlinkExtractor;
import org.eclipse.e4.ui.internal.dialogs.about.HyperlinkRange;
import org.eclipse.e4.ui.internal.dialogs.about.ParsedAbout;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

public class AboutText {
    private String aboutProperty;
    private StyledText styledText;
    private Cursor handCursor;
    private Cursor busyCursor;
    private boolean mouseDown = false;
    private boolean dragEvent = false;
    private ParsedAbout item;

    public AboutText(Supplier<ParsedAbout> item) {
        this.setItem(item.get());
    }

    public AboutText(StyledText text, Supplier<ParsedAbout> item) {
        this.styledText = text;
        this.setItem(item.get());
        this.createCursors();
        this.addListeners();
    }

    public AboutText(String aboutProperty) {
        this.aboutProperty = aboutProperty;
    }

    private void createAboutItem() {
        if (this.aboutProperty == null || this.aboutProperty.isEmpty()) {
            return;
        }
        HyperlinkExtractor hyperlinkExtractor = new HyperlinkExtractor(this.aboutProperty);
        this.setItem(new ParsedAbout(this.aboutProperty, hyperlinkExtractor.getLinkRanges(), hyperlinkExtractor.getLinks()));
    }

    private void createCursors() {
        this.handCursor = new Cursor((Device)this.styledText.getDisplay(), 21);
        this.busyCursor = new Cursor((Device)this.styledText.getDisplay(), 1);
        this.styledText.addDisposeListener(e -> {
            this.handCursor.dispose();
            this.handCursor = null;
            this.busyCursor.dispose();
            this.busyCursor = null;
        });
    }

    protected void addListeners() {
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                AboutText.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent e) {
                AboutText.this.mouseDown = false;
                int offset = AboutText.this.styledText.getCaretOffset();
                Optional<String> link = AboutText.this.safeLinkAt(offset);
                if (AboutText.this.dragEvent) {
                    AboutText.this.dragEvent = false;
                    if (link.isPresent()) {
                        AboutText.this.styledText.setCursor(AboutText.this.handCursor);
                    }
                } else if (link.isPresent()) {
                    AboutText.this.launch(AboutText.this.styledText, link.get());
                }
            }
        });
        this.styledText.addMouseMoveListener(e -> {
            if (this.mouseDown) {
                if (!this.dragEvent) {
                    StyledText text = (StyledText)e.widget;
                    text.setCursor(null);
                }
                this.dragEvent = true;
                return;
            }
            StyledText text = (StyledText)e.widget;
            int offset = -1;
            try {
                offset = text.getOffsetAtPoint(new Point(e.x, e.y));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (offset == -1) {
                text.setCursor(null);
            } else if (this.safeLinkAt(offset).isPresent()) {
                text.setCursor(this.handCursor);
            } else {
                text.setCursor(null);
            }
        });
        this.styledText.addTraverseListener(e -> {
            switch (e.detail) {
                case 2: {
                    e.doit = true;
                    break;
                }
                case 16: {
                    StyleRange nextRange;
                    Point nextSelection = this.styledText.getSelection();
                    int charCount = this.styledText.getCharCount();
                    if (nextSelection.x == charCount && nextSelection.y == charCount) {
                        this.styledText.setSelection(0);
                    }
                    if ((nextRange = this.findNextRange()) == null) {
                        this.styledText.setSelection(0);
                    } else {
                        this.styledText.setSelectionRange(nextRange.start, nextRange.length);
                        e.detail = 0;
                    }
                    e.doit = true;
                    break;
                }
                case 8: {
                    StyleRange previousRange;
                    Point previousSelection = this.styledText.getSelection();
                    if (previousSelection.x == 0 && previousSelection.y == 0) {
                        this.styledText.setSelection(this.styledText.getCharCount());
                    }
                    if ((previousRange = this.findPreviousRange()) == null) {
                        this.styledText.setSelection(this.styledText.getCharCount());
                    } else {
                        this.styledText.setSelectionRange(previousRange.start, previousRange.length);
                        e.detail = 0;
                    }
                    e.doit = true;
                    break;
                }
            }
        });
        this.styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == ' ' || event.character == '\r') {
                    StyledText text = (StyledText)event.widget;
                    int offset = text.getSelection().x + 1;
                    AboutText.this.safeLinkAt(offset).ifPresent(l -> AboutText.this.launch(text, (String)l));
                }
            }
        });
    }

    private Optional<String> safeLinkAt(int offset) {
        return Optional.ofNullable(this.item).flatMap(a -> a.linkAt(offset));
    }

    private void launch(StyledText text, String link) {
        text.setCursor(this.busyCursor);
        Program.launch((String)link);
        StyleRange selectionRange = this.getCurrentRange();
        text.setSelectionRange(selectionRange.start, selectionRange.length);
        text.setCursor(null);
    }

    public Optional<ParsedAbout> getAboutItem() {
        if (this.item == null) {
            this.createAboutItem();
        }
        return Optional.ofNullable(this.item);
    }

    private void setItem(ParsedAbout item) {
        this.item = item;
        if (item != null && this.styledText != null) {
            this.styledText.setText(item.text());
            this.setLinkRanges(item.linkRanges());
        }
    }

    private StyleRange getCurrentRange() {
        StyleRange[] ranges = this.styledText.getStyleRanges();
        int currentSelectionEnd = this.styledText.getSelection().y;
        int currentSelectionStart = this.styledText.getSelection().x;
        return Arrays.stream(ranges).filter(range -> currentSelectionStart >= range.start && currentSelectionEnd <= range.start + range.length).findFirst().orElse(null);
    }

    private StyleRange findNextRange() {
        StyleRange[] ranges = this.styledText.getStyleRanges();
        int currentSelectionEnd = this.styledText.getSelection().y;
        return Arrays.stream(ranges).filter(range -> range.start >= currentSelectionEnd).findFirst().orElse(null);
    }

    private StyleRange findPreviousRange() {
        StyleRange[] ranges = this.styledText.getStyleRanges();
        int currentSelectionStart = this.styledText.getSelection().x;
        int i = ranges.length - 1;
        while (i > -1) {
            if (ranges[i].start + ranges[i].length - 1 < currentSelectionStart) {
                return ranges[i];
            }
            --i;
        }
        return null;
    }

    private void setLinkRanges(List<HyperlinkRange> linkRanges) {
        Color fg = JFaceColors.getHyperlinkText((Display)this.styledText.getShell().getDisplay());
        if (fg == null) {
            JFaceResources.getColorRegistry().put("HYPERLINK_COLOR", new RGB(0, 0, 128));
            fg = JFaceColors.getHyperlinkText((Display)this.styledText.getShell().getDisplay());
        }
        for (HyperlinkRange linkRange : linkRanges) {
            StyleRange range = new StyleRange(linkRange.offset(), linkRange.length(), fg, null);
            this.styledText.setStyleRange(range);
        }
    }
}

