/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.mapping.provider;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.diff.provider.DiffTree;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;

public class ResourceDiffTree
extends DiffTree
implements IResourceDiffTree {
    public static IResource getResourceFor(IDiff node) {
        if (node instanceof IResourceDiff) {
            IResourceDiff rd = (IResourceDiff)node;
            return rd.getResource();
        }
        if (node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            ITwoWayDiff child = twd.getLocalChange();
            if (child != null) {
                return ResourceDiffTree.getResourceFor(child);
            }
            child = twd.getRemoteChange();
            if (child != null) {
                return ResourceDiffTree.getResourceFor(child);
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    @Override
    public IDiff getDiff(IResource resource) {
        return this.getDiff(resource.getFullPath());
    }

    @Override
    public IResource getResource(IDiff diff) {
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            IResourceDiff localChange = (IResourceDiff)twd.getLocalChange();
            if (localChange != null) {
                return localChange.getResource();
            }
            return ((IResourceDiff)twd.getRemoteChange()).getResource();
        }
        return ((IResourceDiff)diff).getResource();
    }

    @Override
    public void accept(ResourceTraversal[] traversals, IDiffVisitor visitor) {
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            IResource[] resources;
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] iResourceArray = resources = traversal.getResources();
            int n3 = resources.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource resource = iResourceArray[n4];
                this.accept(resource.getFullPath(), visitor, traversal.getDepth());
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public IDiff[] getDiffs(ResourceTraversal[] traversals) {
        HashSet<IDiff> result = new HashSet<IDiff>();
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            IResource[] resources;
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] iResourceArray = resources = traversal.getResources();
            int n3 = resources.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource resource = iResourceArray[n4];
                this.internalGetDiffs(resource, traversal.getDepth(), result);
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IDiff[result.size()]);
    }

    @Override
    public IDiff[] getDiffs(IResource resource, int depth) {
        HashSet<IDiff> result = new HashSet<IDiff>();
        this.internalGetDiffs(resource, depth, result);
        return result.toArray(new IDiff[result.size()]);
    }

    private void internalGetDiffs(IResource resource, int depth, Set<IDiff> result) {
        this.accept(resource.getFullPath(), diff -> result.add(diff), depth);
    }

    private IResource internalGetResource(IPath fullPath, boolean container) {
        if (container) {
            if (fullPath.segmentCount() == 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(fullPath.segment(0));
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFolder(fullPath);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath);
    }

    @Override
    public IResource[] members(IResource resource) {
        IPath[] paths;
        ArrayList<IResource> result = new ArrayList<IResource>();
        IPath[] iPathArray = paths = this.getChildren(resource.getFullPath());
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            IDiff node = this.getDiff(path);
            if (node == null) {
                result.add(this.internalGetResource(path, true));
            } else {
                result.add(this.getResource(node));
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    @Override
    public IResource[] getAffectedResources() {
        IDiff[] nodes;
        ArrayList<IResource> result = new ArrayList<IResource>();
        IDiff[] iDiffArray = nodes = this.getDiffs();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff node = iDiffArray[n2];
            result.add(this.getResource(node));
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    @Override
    public void add(IDiff delta) {
        Assert.isTrue((delta instanceof IResourceDiff || delta instanceof IThreeWayDiff ? 1 : 0) != 0);
        super.add(delta);
    }

    public void remove(IResource resource) {
        this.remove(resource.getFullPath());
    }

    @Override
    public boolean hasMatchingDiffs(ResourceTraversal[] traversals, FastDiffFilter filter) {
        RuntimeException found = new RuntimeException();
        try {
            this.accept(traversals, delta -> {
                if (filter.select(delta)) {
                    throw found;
                }
                return false;
            });
        }
        catch (RuntimeException e) {
            if (e == found) {
                return true;
            }
            throw e;
        }
        return false;
    }
}

