/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.SwtCallable;
import org.eclipse.swt.SwtRunnable;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BusyIndicator {
    private static final AtomicInteger nextBusyId = new AtomicInteger();
    static final String BUSYID_NAME = "SWT BusyIndicator";
    static final String BUSY_CURSOR = "SWT BusyIndicator Cursor";

    public static void showWhile(Display display, Runnable runnable) {
        if (runnable == null) {
            SWT.error(4);
        }
        if (display == null && (display = Display.getCurrent()) == null) {
            runnable.run();
            return;
        }
        Integer busyId = BusyIndicator.setBusyCursor(display);
        try {
            runnable.run();
        }
        finally {
            BusyIndicator.clearBusyCursor(display, busyId);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void showWhile(final Future<?> future) {
        if (future == null) {
            SWT.error(4);
        }
        if (future.isDone()) return;
        final Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            try {
                future.get();
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException e) {
                return;
            }
            catch (CancellationException e) {
                return;
            }
        }
        Integer busyId = BusyIndicator.setBusyCursor(display);
        try {
            if (future instanceof CompletionStage) {
                CompletionStage stage = (CompletionStage)((Object)future);
                stage.handle((nil1, nil2) -> {
                    if (!display.isDisposed()) {
                        try {
                            display.wake();
                        }
                        catch (SWTException sWTException) {
                            // empty catch block
                        }
                    }
                    return null;
                });
                if (future.isDone()) return;
                if (display.isDisposed()) {
                    return;
                }
            } else {
                final int wakeTime = 10;
                display.timerExec(wakeTime, new Runnable(){

                    @Override
                    public void run() {
                        if (!future.isDone() && !display.isDisposed()) {
                            display.timerExec(wakeTime, this);
                        }
                    }
                });
                if (true) {
                    if (future.isDone()) return;
                    if (display.isDisposed()) return;
                }
            }
            do {
                if (!display.readAndDispatch()) {
                    display.sleep();
                }
                if (future.isDone()) return;
            } while (!display.isDisposed());
            return;
        }
        finally {
            BusyIndicator.clearBusyCursor(display, busyId);
        }
    }

    public static <E extends Exception> CompletableFuture<?> execute(SwtRunnable<E> action) {
        return BusyIndicator.execute(action, ForkJoinPool.commonPool());
    }

    public static <E extends Exception> CompletableFuture<?> execute(SwtRunnable<E> action, Executor executor) {
        return BusyIndicator.compute(() -> {
            action.run();
            return null;
        }, executor);
    }

    public static <V, E extends Exception> CompletableFuture<V> compute(SwtCallable<V, E> action) {
        return BusyIndicator.compute(action, ForkJoinPool.commonPool());
    }

    public static <V, E extends Exception> CompletableFuture<V> compute(SwtCallable<V, E> action, Executor executor) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(executor);
        if (executor instanceof Display) {
            throw new IllegalArgumentException("passing a Display as an executor is not allowed!");
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null) {
            try {
                V inplaceResult = action.call();
                return CompletableFuture.completedFuture(inplaceResult);
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }
        Integer busyId = BusyIndicator.setBusyCursor(display);
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> {
            block5: {
                if (!future.isCancelled()) break block5;
                display.asyncExec(() -> BusyIndicator.clearBusyCursor(display, busyId));
                return;
            }
            try {
                try {
                    Object asyncResult = action.call();
                    future.complete(asyncResult);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    display.asyncExec(() -> BusyIndicator.clearBusyCursor(display, busyId));
                }
            }
            catch (Throwable throwable) {
                display.asyncExec(() -> BusyIndicator.clearBusyCursor(display, busyId));
                throw throwable;
            }
            display.asyncExec(() -> BusyIndicator.clearBusyCursor(display, busyId));
        });
        return future;
    }

    private static void clearBusyCursor(Display display, Integer busyId) {
        Shell[] shells;
        if (display.isDisposed()) {
            return;
        }
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            Integer id = (Integer)shell.getData(BUSYID_NAME);
            if (Objects.equals(id, busyId)) {
                BusyIndicator.setCursorAndId(shell, null, null);
            }
            ++n2;
        }
    }

    private static Integer setBusyCursor(Display display) {
        Shell[] shells;
        Integer busyId = nextBusyId.getAndIncrement();
        Cursor cursor = display.getSystemCursor(1);
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            Integer id = (Integer)shell.getData(BUSYID_NAME);
            if (id == null) {
                BusyIndicator.setCursorAndId(shell, cursor, busyId);
            }
            ++n2;
        }
        return busyId;
    }

    private static void setCursorAndId(Shell shell, Cursor cursor, Integer busyId) {
        if (!shell.isDisposed()) {
            shell.setCursor(cursor);
        }
        if (!shell.isDisposed()) {
            shell.setData(BUSYID_NAME, busyId);
        }
    }
}

