/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gaussdb.model;

public enum DBCompatibilityEnum {
    ORACLE("Oracle", "A", "ORA"),
    MYSQL("MySQL", "B", "MYSQL"),
    TEDATA("Teradata", "C", "TD"),
    POSTGRES("PostgreSQL", "PG", "PG");

    private final String text;
    private final String cValue;
    private final String dValue;

    private DBCompatibilityEnum(String text, String cValue, String dValue) {
        this.text = text;
        this.cValue = cValue;
        this.dValue = dValue;
    }

    public String getText() {
        return this.text;
    }

    public String getcValue() {
        return this.cValue;
    }

    public String getdValue() {
        return this.dValue;
    }

    public static DBCompatibilityEnum of(String text) {
        DBCompatibilityEnum[] enums;
        DBCompatibilityEnum[] dBCompatibilityEnumArray = enums = DBCompatibilityEnum.values();
        int n = enums.length;
        int n2 = 0;
        while (n2 < n) {
            DBCompatibilityEnum e = dBCompatibilityEnumArray[n2];
            if (e.getText().equals(text)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static String queryTextByValue(String value) {
        DBCompatibilityEnum[] enums;
        DBCompatibilityEnum[] dBCompatibilityEnumArray = enums = DBCompatibilityEnum.values();
        int n = enums.length;
        int n2 = 0;
        while (n2 < n) {
            DBCompatibilityEnum e = dBCompatibilityEnumArray[n2];
            if (e.cValue.equalsIgnoreCase(value) || e.dValue.equalsIgnoreCase(value)) {
                return e.text;
            }
            ++n2;
        }
        return "";
    }
}

